import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import { useHydrated } from "./use-hydrated";
/**
 * Render the children only before the JS has loaded client-side. Use an
 * optional fallback component for once the JS has loaded.
 *
 * Example: Render a hidden input to identify if the user has JS.
 * ```tsx
 * return (
 *   <ServerOnly fallback={<FakeChart />}>
 *     {() => <Chart />}
 *   </ServerOnly>
 * );
 * ```
 */
export function ServerOnly({ children, fallback = null }) {
    return useHydrated() ? _jsx(_Fragment, { children: fallback }) : _jsx(_Fragment, { children: children() });
}
