/**
 * This is a helper hook that returns the state of every fetcher active on
 * the app and combine it with the state of the global transition.
 * @example
 * let states = useGlobalTransitionStates();
 * if (state.includes("loading")) {
 *   // The app is loading.
 * }
 * if (state.includes("submitting")) {
 *   // The app is submitting.
 * }
 * // The app is idle
 */
export declare function useGlobalTransitionStates(): ("idle" | "submitting" | "loading")[];
/**
 * Let you know if the app is pending some request, either global transition
 * or some fetcher transition.
 * @returns "idle" | "pending"
 */
export declare function useGlobalPendingState(): "idle" | "pending";
/**
 * Let you know if the app is submitting some request, either global transition
 * or some fetcher transition.
 * @returns "idle" | "submitting"
 */
export declare function useGlobalSubmittingState(): "idle" | "submitting";
/**
 * Let you know if the app is loading some request, either global transition
 * or some fetcher transition.
 * @returns "idle" | "loading"
 */
export declare function useGlobalLoadingState(): "idle" | "loading";
