"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StructuredData = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("@remix-run/react");
function isHandleStructuredData(handle) {
    return (handle !== undefined &&
        handle.structuredData !== undefined &&
        typeof handle.structuredData === "function");
}
/**
 * Render "application/ld+json" script tags for structured data (https://developers.google.com/search/docs/advanced/structured-data/intro-structured-data)
 *
 * @deprecated Use new V2_MetaFunction instead
 * @see https://remix.run/docs/en/main/route/meta-v2
 *
 * @example
 * // This route uses the data to render structured data (e.g. BreadcrumbList and BlogPosting)
 * export let handle: HandleStructuredData<LoaderData, BlogPosting> = {
 *    structuredData({ data }) {
 *      let { post } = data;
 *
 *      return {
 *        '@context': 'https://schema.org',
 *        '@type': 'BlogPosting',
 *        datePublished: post.published,
 *        mainEntityOfPage: {
 *          '@type': 'WebPage',
 *          '@id': post.postUrl,
 *        },
 *        image: post.featuredImage,
 *        author: {
 *          '@type': 'Person',
 *          name: post.authorName,
 *        },
 *      };
 *    },
 * };
 */
function StructuredData() {
    let location = (0, react_1.useLocation)();
    let structuredData = (0, react_1.useMatches)().flatMap((match, index, matches) => {
        if (isHandleStructuredData(match.handle)) {
            let result = match.handle.structuredData({
                id: match.id,
                data: match.data,
                params: match.params,
                location,
                parentsData: matches.slice(0, index).map((match) => match.data),
                matches,
            });
            if (result)
                return result;
        }
        return [];
    });
    if (structuredData.length === 0) {
        return null;
    }
    let renderedScript = structuredData.length === 1
        ? JSON.stringify(structuredData[0])
        : JSON.stringify(structuredData);
    return ((0, jsx_runtime_1.jsx)("script", { type: "application/ld+json", dangerouslySetInnerHTML: {
            __html: renderedScript,
        } }));
}
exports.StructuredData = StructuredData;
