"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrefetchPageAnchors = exports.useDelegatedAnchors = exports.isLinkEvent = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("@remix-run/react");
const react_2 = require("react");
const context = (0, react_2.createContext)(false);
function isLinkEvent(event) {
    if (!(event.target instanceof HTMLElement))
        return;
    let a = event.target.closest("a");
    if (a && a.hasAttribute("href") && a.host === window.location.host)
        return a;
    return;
}
exports.isLinkEvent = isLinkEvent;
function useDelegatedAnchors(nodeRef) {
    let navigate = (0, react_1.useNavigate)();
    let hasParentPrefetch = (0, react_2.useContext)(context);
    (0, react_2.useEffect)(() => {
        // if you call useDelegatedAnchors as a children of a PrefetchPageAnchors
        // then do nothing
        if (hasParentPrefetch)
            return;
        let node = nodeRef.current;
        node === null || node === void 0 ? void 0 : node.addEventListener("click", handleClick);
        return () => node === null || node === void 0 ? void 0 : node.removeEventListener("click", handleClick);
        function handleClick(event) {
            if (!node)
                return;
            let anchor = isLinkEvent(event);
            if (!anchor)
                return;
            if (event.button !== 0)
                return;
            if (anchor.target && anchor.target !== "_self")
                return;
            if (event.metaKey || event.altKey || event.ctrlKey || event.shiftKey) {
                return;
            }
            if (anchor.hasAttribute("download"))
                return;
            let { pathname, search, hash } = anchor;
            navigate({ pathname, search, hash });
            event.preventDefault();
        }
    }, [hasParentPrefetch, navigate, nodeRef]);
}
exports.useDelegatedAnchors = useDelegatedAnchors;
function PrefetchPageAnchors({ children }) {
    let nodeRef = (0, react_2.useRef)(null);
    let [page, setPage] = (0, react_2.useState)(null);
    let hasParentPrefetch = (0, react_2.useContext)(context);
    // prefetch is useless without delegated anchors, so we enable it
    useDelegatedAnchors(nodeRef);
    (0, react_2.useEffect)(() => {
        if (hasParentPrefetch)
            return;
        let node = nodeRef.current;
        node === null || node === void 0 ? void 0 : node.addEventListener("mouseenter", handleMouseEnter, true);
        return () => node === null || node === void 0 ? void 0 : node.removeEventListener("mouseenter", handleMouseEnter);
        function handleMouseEnter(event) {
            if (!nodeRef.current)
                return;
            let anchor = isLinkEvent(event);
            if (!anchor)
                return;
            let { pathname, search } = anchor;
            setPage(pathname + search);
        }
    }, [hasParentPrefetch]);
    return ((0, jsx_runtime_1.jsxs)("div", { ref: nodeRef, style: { display: "contents" }, children: [(0, jsx_runtime_1.jsx)(context.Provider, { value: true, children: children }), page && !hasParentPrefetch && (0, jsx_runtime_1.jsx)(react_1.PrefetchPageLinks, { page: page })] }));
}
exports.PrefetchPageAnchors = PrefetchPageAnchors;
