"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClientLocales = void 0;
const intl_parse_accept_language_1 = require("intl-parse-accept-language");
const get_headers_1 = require("./get-headers");
function getClientLocales(requestOrHeaders) {
    let headers = (0, get_headers_1.getHeaders)(requestOrHeaders);
    let acceptLanguage = headers.get("Accept-Language");
    // if the header is not defined, return undefined
    if (!acceptLanguage)
        return undefined;
    let locales = (0, intl_parse_accept_language_1.parseAcceptLanguage)(acceptLanguage, {
        validate: Intl.DateTimeFormat.supportedLocalesOf,
        ignoreWildcard: true,
    });
    // if there are no locales found, return undefined
    if (locales.length === 0)
        return undefined;
    // if there are multiple locales, return the array
    return locales;
}
exports.getClientLocales = getClientLocales;
