# TW Elements [<img src="https://tecdn.b-cdn.net/img/logo/te-transparent-noshadows.webp" width="45" align="right" alt="tw-elements">](https://tw-elements.com/)<a href="https://www.npmjs.com/package/tw-elements"><img src="https://img.shields.io/npm/dt/tw-elements.svg" alt="Total Downloads"></a> <a href="https://github.com/mdbootstrap/TW-Elements/releases"><img src="https://img.shields.io/npm/v/tw-elements.svg" alt="Latest Release"></a> <a href="https://twitter.com/intent/tweet/?text=Thanks+@TWElement+for+creating+an+amazing+collection+of+open+source+components+for+@tailwindcss%20https://tw-elements.com/&hashtags=tailwindCSS,bootstrap,webdesign,javascript,100DaysOfCode,DevCommunity"><img src="https://img.shields.io/twitter/url/http/shields.io.svg?style=social&label=Let%20us%20know%20you%20were%20here%21&"></a>

TW Elements is a huge collection of free, interactive components for Tailwind CSS.

 <table>
    <tbody>
    <tr>
      <td>
          <a href="https://tw-elements.com/" alt="TW Elements tutorials" rel="dofollow">
          		<img width="600" src="https://tecdn.b-cdn.net/img/components-big.jpg">
          </a>
      </td>
      <td>    
        <ul>
         <li>500+ UI components</li>
         <li>117+ design blocks</li>         
         <li>Dark mode support</li>      
         <li>Easy theming & customization</li>
         <li>Simple, 1 minute install</li>    
         <li>Free for personal & commercial use</li>
        </ul>
        <p><b><a href="https://tw-elements.com/docs/standard/getting-started/quick-start/">Get started with TW Elements now!</a></b></p>
      </td>
    </tr>
   </tbody>
  </table>

---

## Table of Contents

- [Table of Contents](#table-of-contents)
- [Community](#community)
- [Coming soon](#coming-soon)
- [Components](#components)
- [Design blocks](#design-blocks)
- [Installation](#installation)

---

## Community

TW Elements is a **community-driven** project.
We invite you to **track our [live progress 👁️](https://github.com/orgs/mdbootstrap/projects/1)** on the upcoming release.

In the meantime you can also:

- Motivate us with some [words of encouragament ❤️](https://github.com/mdbootstrap/TW-Elements/discussions/categories/kind-words-general-feedback)
- Share your [ideas & feature requests 💡](https://github.com/mdbootstrap/TW-Elements/discussions/categories/share-ideas-request-features)
- Aks for help & help others in our [community support 🙏](https://github.com/mdbootstrap/TW-Elements/discussions/categories/support-from-community)
- **Engage, discuss & have fun in our [open-source community 💬](https://github.com/mdbootstrap/TW-Elements/discussions)**

**If you want to help the project grow, start by simply sharing it with your peers!**

- [Share via Dev.to](<https://dev.to/new?prefill=---%0Atitle%3A%20500+%20open-source%20components%20for%20TailwindCSS%20%0Apublished%3A%20true%0Atags%3Atailwindcss%0A---%0A%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20[![Tailwind%20components](https://tw-elements.com/img/components-big.jpg)](https://tw-elements.com/)%20%20%20%20%20%20%20%20\n%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20I%27d%20like%20to%20share%20my%20latest%20discovery%20with%20you.%20\n%20%20%20%20%20%20%20%20[Tailwind%20Elements](https://tw-elements.com/)%20is%20currently,%20the%20most%20popular%203rd%20party%20UI%20kit%20for%20TailwindCSS%20with%20over%2010k%20Github%20stars.%20%20%20%20%20%20%20%20[![GitHub%20Repo%20stars](https://img.shields.io/github/stars/mdbootstrap/tw-elements?style=social)](https://github.com/mdbootstrap/TW-Elements/)%20%20%20%20%20%20%20%20It%27s%20a%20**huge%20collection%20of%20stunning%20components**%20made%20with%20attention%20to%20the%20smallest%20detail.%20%20%20%20%20%20%20%20%20Forms,%20cards,%20buttons,%20and%20hundreds%20of%20others.%20%20%20%20%20%20%20%20%20All%20components%20have%20**dark%20mode**%20and%20very%20intuitive%20**theming%20options**.%20%20%20%20%20%20%20%20The%20project%20is%20supported%20by%20an%20[engaged%20community%20on%20GitHub](https://github.com/mdbootstrap/TW-Elements/discussions),%20I%20recommend%20you%20check%20it%20out%20and%20join%20one%20of%20the%20many%20discussions.%20%20%20%20%20%20%20%20\n%20%20%20%20%20%20%20%20You%20will%20find%20installation%20instructions%20[here](https://tw-elements.com/docs/getting-started/installation),%20and%20you%20can%20track%20the%20progress%20of%20the%20project%20live%20%20%20%20%20%20%20%20%20[here](https://tw-elements.com/docs/standard/getting-started/changelog/).%20%20%20%20%20%20%20%20\n%20%20%20%20%20%20%20%20The%20project%20was%20kickstarted%20by%20@MDBootstrap,%20a%20group%20of%20open-source%20developers%20behind%20[MDB%20UI%20Kit](https://github.com/mdbootstrap/mdb-ui-kit)%20-%20a%20high-quality%20UI%20kit%20for%20Bootstrap,%20and%20also%20behind%20[MDB%20GO](https://mdbgo.com/)%20-%20hosting%20and%20deployment%20platform.%20%20%20%20%20%20%20%20\n%20%20%20%20%20%20%20%20I%20highly%20recommend%20you%20to%20check%20it%20out!%20%20%20%20%20%20%20%20\n%20%20%20%20%20%20%20%20%7B%25%20link%20mdbootstrap/tw-elements-breakthrough-version-is-here-59hh%20%25%7D%20%20%20%20%20%20%20%20\n>)
- [Share via Twitter](https://twitter.com/intent/tweet?text=500%2B%20open-source%20components%20for%20%23TailwindCSS%20%F0%9F%A4%A9%0Ahttps%3A//tw-elements.com/%0A%0ACongrats%20%40MDBootstrap%20%40ascensus_mdb%20%40dawidadach%20for%20this%20awesome%20design%20collection!%0A%0AI%20will%20keep%20using%20it%20in%20my%20projects%20for%20sure!%0A%0A%23uiux%20%23webdevelopment%20%23HTML%20%23CSS%20%23design%20%23Webdesign%20%23programming%20)
- [Share via Facebook](https://www.facebook.com/sharer/sharer.php?u=https%3A//tw-elements.com)
- [Share via LinkedIn](http://www.linkedin.com/shareArticle?url=https%3A%2F%2Ftw-elements.com%2F&title=500%2B%20open-source%20components%20for%20TailwindCSS)
- [Share via Pinterest](https://www.pinterest.com/pin/create/button?url=https://tw-elements.com/&media=https://tw-elements.com/img/components-big.jpg&description=TailwindElements)
- [Share via Reddit](https://reddit.com/submit?url=https://tw-elements.com/&title=500+%20open-source%20components%20for%20TailwindCSS)
- [Share via StumbleUpon](https://www.stumbleupon.com/submit?url=https://tw-elements.com/&title=500+%20open-source%20components%20for%20TailwindCSS)
- [Share via Vkontakte](https://vk.com/share.php?url=https://tw-elements.com/)
- [Share via Weibo](https://service.weibo.com/share/share.php?url=https://tw-elements.com/&title=500+%20open-source%20components%20for%20TailwindCSS)
- [Share via Hackernews](https://news.ycombinator.com/submitlink?u=https://tw-elements.com/&t=500+%20open-source%20components%20for%20TailwindCSS)
- [Share via Gmail](https://mail.google.com/mail/?view=cm&to=%7Bemail_address%7D&su=Check%20out%20this%20project&body=Hello,%0AI%27m%20reaching%20out%20to%20recommend%20my%20latest%20discovery.%0A%0AIt%27s%20over%20500+%20open-source%20components%20for%20TailwindCSS%20with%20excellent%20support%20and%20an%20awesome%20community:%0Ahttps://tw-elements.com/%0A%0AI%20hope%20you%20will%20find%20it%20useful.%0ABest%20regards,&bcc=%7Bemail_address%7D&cc=%7Bemail_address%7D)
- [Share via email](mailto:?subject=Check%20out%20this%20project&body=Hello%2C%0AI'm%20reaching%20out%20to%20recommend%20my%20latest%20discovery.%0A%0AIt's%20over%20500%20%20open-source%20components%20for%20Tailwind%20CSS%20with%20excellent%20support%20and%20an%20awesome%20community%3A%0Ahttps%3A%2F%2Ftw-elements.com%2F%0A%0AI%20hope%20you%20will%20find%20it%20useful.%0ABest%20regards%2C)

Thank you!

---

## Coming soon

Check out the upcoming features - make sure to **join the waiting list** in order to **get early access**!

 <table>
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/builder/">
            <img alt="Design blocks" src="https://mdbootstrap.com/img/tw-demo/drag-and-drop.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/templates/">
            <img alt="Templates" src="https://mdbootstrap.com/img/tw-demo/templates.webp">
        </a>
    </td>    
  </tr>
  <tr>
    <td align="center"><b>Drag & drop builder</b></td>
    <td align="center"><b>Templates</b></td>
  </tr>
</table>

---

## Components

A collection of stunning components made with attention to the smallest details. Forms, cards, buttons, and hundreds of others – in TW Elements you will find all the essential elements necessary for every project.

<table>
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/datepicker/">
            <img alt="Datepicker" src="https://mdbootstrap.com/img/tw-demo/datepicker.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/dropdown/">
            <img alt="Dropdown" src="https://mdbootstrap.com/img/tw-demo/dropdown.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/modal/">
            <img alt="Modal" src="https://mdbootstrap.com/img/tw-demo/modal.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Datepicker</b></td>
    <td align="center"><b>Dropdown</b></td>
    <td align="center"><b>Modal</b></td>
  </tr>
  
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/data/charts/">
            <img alt="Charts" src="https://mdbootstrap.com/img/tw-demo/charts.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/tooltip/">
            <img alt="Tooltips" src="https://mdbootstrap.com/img/tw-demo/tooltips-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/carousel/">
            <img alt="Carousel" src="https://mdbootstrap.com/img/tw-demo/carousel.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Charts</b></td>
    <td align="center"><b>Tooltips</b></td>
    <td align="center"><b>Carousel</b></td>
  </tr>
  
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/accordion/">
            <img alt="Accordion" src="https://mdbootstrap.com/img/tw-demo/accordion.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/navigation/tabs/">
            <img alt="Tabs" src="https://mdbootstrap.com/img/tw-demo/tabs.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/stepper/">
            <img alt="Stepper" src="https://mdbootstrap.com/img/tw-demo/stepper.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Accordion</b></td>
    <td align="center"><b>Tabs</b></td>
    <td align="center"><b>Stepper</b></td>
  </tr>
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/timepicker/">
            <img alt="Tailwind CSS Time picker" src="https://mdbootstrap.com/img/tw-demo/timepicker.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/navigation/footer/">
            <img alt="Tailwind CSS Tables" src="https://mdbootstrap.com/img/tw-demo/footer.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/navigation/navbar/">
            <img alt="Tailwind CSS Navbar" src="https://mdbootstrap.com/img/tw-demo/navbar.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Timepicker</b></td>
    <td align="center"><b>Footer</b></td>
    <td align="center"><b>Navbar</b></td>
  </tr>
  <!--New row-->
    <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/alerts/">
            <img alt="Tailwind CSS Time picker" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-pro/alert-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/avatar/">
            <img alt="Tailwind CSS Tables" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/avatar.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/badges/">
            <img alt="Tailwind CSS Navbar" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/badge-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Alerts</b></td>
    <td align="center"><b>Avatar</b></td>
    <td align="center"><b>Badges</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/button-group/">
            <img alt="Tailwind CSS Time picker" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/button-group-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/buttons/">
            <img alt="Tailwind CSS Tables" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/button-2.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/cards/">
            <img alt="Tailwind CSS Navbar" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/card-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Button group</b></td>
    <td align="center"><b>Buttons</b></td>
    <td align="center"><b>Cards</b></td>
  </tr>
<!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/chips/">
            <img alt="Tailwind CSS Time picker" src="https://mdbcdn.b-cdn.net/wp-content/themes/mdbootstrap4/content/en/_mdb5/standard/pro/demo-new/assets/images/chips.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/collapse/">
            <img alt="Tailwind CSS Tables" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/collapse-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/gallery/">
            <img alt="Tailwind CSS Navbar" src="https://mdbcdn.b-cdn.net/wp-content/themes/mdbootstrap4/content/en/_mdb5/standard/pro/demo-new/assets/images/lightbox.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Chips</b></td>
    <td align="center"><b>Collapse</b></td>
    <td align="center"><b>Gallery</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/jumbotron/">
            <img alt="Tailwind CSS Time picker" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/header-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/link/">
            <img alt="Tailwind CSS Tables" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/link.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/listgroup/">
            <img alt="Tailwind CSS Navbar" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/list-group-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Jumbotron</b></td>
    <td align="center"><b>Link</b></td>
    <td align="center"><b>List group</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/notifications/">
            <img alt="Tailwind CSS Time picker" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/notification.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/paragraphs/">
            <img alt="Tailwind CSS Tables" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/paragraphs.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/placeholders/">
            <img alt="Tailwind CSS Navbar" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/placeholder-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Notifications</b></td>
    <td align="center"><b>Paragraphs</b></td>
    <td align="center"><b>Placeholders</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/popover/">
            <img alt="Tailwind CSS Time picker" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/popover-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/progress/">
            <img alt="Tailwind CSS Tables" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/progress-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/rating/">
            <img alt="Tailwind CSS Navbar" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-pro/rating-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Popover</b></td>
    <td align="center"><b>Progress</b></td>
    <td align="center"><b>Rating</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/scroll-back-to-top-button/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/scroll-back-to-top.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/social-buttons/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/social-media.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/spinners/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/spinner-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Scroll to top</b></td>
    <td align="center"><b>Social buttons</b></td>
    <td align="center"><b>Spinners</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/timeline/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/timeline.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/toast/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-pro/toast-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/tooltip/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/tooltip-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Timeline</b></td>
    <td align="center"><b>Toast</b></td>
    <td align="center"><b>Tooltip</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/video/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/video.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/video-carousel/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/video-carousel.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/checkbox/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/checkbox-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Video</b></td>
    <td align="center"><b>Video carousel</b></td>
    <td align="center"><b>Checkbox</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/file-input/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/file-upload.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/input-group/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/input-group.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/login-form/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/login-form.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>File input</b></td>
    <td align="center"><b>Input group</b></td>
    <td align="center"><b>Login form</b></td>
  </tr>  
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/radio/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/radio-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/range/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/range-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/registration-form/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/registration-form.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Radio</b></td>
    <td align="center"><b>Range</b></td>
    <td align="center"><b>Registration form</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/search/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/search-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/select/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-pro/select-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/switch/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/switch.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Search</b></td>
    <td align="center"><b>Select</b></td>
    <td align="center"><b>Switch</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/forms/textarea/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/textarea.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/data/tables/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/table-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/methods/ripple/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/ripple.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Textarea</b></td>
    <td align="center"><b>Tables</b></td>
    <td align="center"><b>Ripple</b></td>
  </tr>
<!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/content-styles/animations/">
            <img alt="Tailwind Component" src="https://mdbcdn.b-cdn.net/wp-content/themes/mdbootstrap4/content/en/_mdb5/standard/pro/demo-new/assets/images/animations2.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/content-styles/mask/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/mask-1.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/content-styles/shadows/">
            <img alt="Tailwind Component" src="https://mdbootstrap.com/docs/standard/pro/demo/assets/images/components-free/shadow-1.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Animations</b></td>
    <td align="center"><b>Masks</b></td>
    <td align="center"><b>Shadows</b></td>
  </tr>
  <!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/data/datatables/">
            <img alt="Tailwind Component" src="https://mdbcdn.b-cdn.net/docs/standard/pro/demo/assets/images/datatable.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/lightbox/">
            <img alt="Tailwind Component" src="https://mdbcdn.b-cdn.net/docs/standard/pro/demo/assets/images/lightbox.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/rating/">
            <img alt="Tailwind Component" src="https://mdbcdn.b-cdn.net/docs/standard/pro/demo/assets/images/rating.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Datatables</b></td>
    <td align="center"><b>Lightbox</b></td>
    <td align="center"><b>Rating</b></td>
  </tr>
<!--New row-->
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/methods/scrollbar/">
            <img alt="Tailwind Component" src="https://mdbcdn.b-cdn.net/docs/standard/pro/demo/assets/images/scrollbar.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/components/popconfirm/">
            <img alt="Tailwind Component" src="https://mdbcdn.b-cdn.net/docs/standard/pro/demo/assets/images/popconfirm.webp">
        </a>
    </td>
     <td>
        <a href="https://tw-elements.com/">
            <img alt="Logo Clouds" src="https://mdbootstrap.com/img/tw-demo/design-blocks.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Scrollbar</b></td>
    <td align="center"><b>Popconfirm</b></td>
    <td align="center"><b>More coming soon</b></td>
  </tr>

</table>

---

## Design blocks

Responsive Landing page blocks built with Tailwind CSS. Plenty of design blocks examples such as Teams, services, projects, faq, and many more.

<table>
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/hero-sections/">
            <img alt="Hero" src="https://mdbootstrap.com/img/tw-demo/hero.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/pricing/">
            <img alt="Pricing" src="https://mdbootstrap.com/img/tw-demo/pricing.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/cta/">
            <img alt="Call to action" src="https://mdbootstrap.com/img/tw-demo/cta.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Hero</b></td>
    <td align="center"><b>Pricing</b></td>
    <td align="center"><b>Call to action</b></td>
  </tr>
  
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/features/">
            <img alt="Features" src="https://mdbootstrap.com/img/tw-demo/features.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/contact/">
            <img alt="Contact" src="https://mdbootstrap.com/img/tw-demo/contact.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/news/">
            <img alt="News/blog" src="https://mdbootstrap.com/img/tw-demo/news.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Features</b></td>
    <td align="center"><b>Contact</b></td>
    <td align="center"><b>News/blog</b></td>
  </tr>
  
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/team/">
            <img alt="Team" src="https://mdbootstrap.com/img/tw-demo/team.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/stats/">
            <img alt="Tabs" src="https://mdbootstrap.com/img/tw-demo/stats.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/testimonials/">
            <img alt="Stepper" src="https://mdbootstrap.com/img/tw-demo/testimonials.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Team</b></td>
    <td align="center"><b>Stats</b></td>
    <td align="center"><b>Testimonials</b></td>
  </tr>
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/content/">
            <img alt="Content" src="https://mdbootstrap.com/img/tw-demo/content.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/newsletter/">
            <img alt="Newsletter" src="https://mdbootstrap.com/img/tw-demo/newsletter.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/project-sections/">
            <img alt="Projects" src="https://mdbootstrap.com/img/tw-demo/projects.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Content</b></td>
    <td align="center"><b>Newsletter</b></td>
    <td align="center"><b>Projects</b></td>
  </tr>
  <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/headers/">
            <img alt="Headers" src="https://mdbootstrap.com/img/tw-demo/headers.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/faq/">
            <img alt="FAQ" src="https://mdbootstrap.com/img/tw-demo/faq.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/logo-clouds/">
            <img alt="Logo Clouds" src="https://mdbootstrap.com/img/tw-demo/logo-clouds.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Headers</b></td>
    <td align="center"><b>FAQ</b></td>
    <td align="center"><b>Logo Clouds</b></td>
  </tr>
    <tr>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/banners/">
            <img alt="Headers" src="https://mdbootstrap.com/img/tw-demo/banners.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/docs/standard/designblocks/mega-menu/">
            <img alt="FAQ" src="https://mdbootstrap.com/img/tw-demo/mega-menu.webp">
        </a>
    </td>
    <td>
        <a href="https://tw-elements.com/">
            <img alt="Logo Clouds" src="https://mdbootstrap.com/img/tw-demo/design-blocks.webp">
        </a>
    </td>
  </tr>
  <tr>
    <td align="center"><b>Banners</b></td>
    <td align="center"><b>Mega Menu</b></td>
    <td align="center"><b>More coming soon</b></td>
  </tr>
</table>

---

## Installation

##### NPM

1. Before starting the project make sure to install [Node.js (LTS)](https://nodejs.org/en/ "Node.js (LTS)") and [TailwindCSS](https://tailwindcss.com/ "TailwindCSS").

2. Run the following command to install the package via NPM:

```
npm install tw-elements
```

3. TW Elements is a plugin and should be included inside the **tailwind.config.js** file. It is also recommended to extend the content array with a js file that loads dynamic component classes:

```javascript
module.exports = {
  content: [
    "./src/**/*.{html,js}",
    "./node_modules/tw-elements/dist/js/**/*.js",
  ],
  plugins: [require("tw-elements/dist/plugin")],
  darkMode: "class",
};
```

4.  Dynamic components will work after adding the js file:

```
<script src="./TW-ELEMENTS-PATH/dist/js/tw-elements.umd.min.js"></script>
```

Alternatively, you can import it in the following way (bundler version):

```
import 'tw-elements';
```

##### MDB GO / CLI

Create, deploy and host anything with a single command.

1. To start using MDB GO / CLI install it with one command:

```
npm install -g mdb-cli
```

2. Log into the CLI using your MDB account:

```
mdb login
```

3. Initialize a project and choose **Tailwind Elements** from the list:

```
mdb init tailwind-elements-free
```

4. Install the dependencies (inside the project directory):

```
npm install
```

5. Run the app:

```
npm start
```

6. Publish when you're ready:

```
mdb publish
```

##### CDN

You can easily test TW Elements by adding CDN scripts to your classic HTML template without the need for installing any packages.

Add the stylesheet files below in the _head_ section:

```
<link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900&display=swap" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tw-elements/dist/css/tw-elements.min.css" />
<script src="https://cdn.tailwindcss.com"></script>
<script>
  tailwind.config = {
    darkMode: "class",
    theme: {
      fontFamily: {
        sans: ["Roboto", "sans-serif"],
        body: ["Roboto", "sans-serif"],
        mono: ["ui-monospace", "monospace"],
      },
    },
    corePlugins: {
      preflight: false,
    },
  };
</script>
```

Require the js bundled file right before the _body_ closing tag:

```
<script src="https://cdn.jsdelivr.net/npm/tw-elements/dist/js/tw-elements.umd.min.js"></script>
```
