"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccordionContent = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const AccordionPanelContext_1 = require("./AccordionPanelContext");
const AccordionContent = ({ children, className, theme: customTheme = {}, ...props }) => {
    const { isOpen } = (0, AccordionPanelContext_1.useAccordionContext)();
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.accordion.content, customTheme);
    return ((0, jsx_runtime_1.jsx)("div", { className: (0, classnames_1.default)(theme.base, className), "data-testid": "flowbite-accordion-content", hidden: !isOpen, ...props, children: children }));
};
exports.AccordionContent = AccordionContent;
