"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Alert = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const hi_1 = require("react-icons/hi");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const Alert = ({ additionalContent, children, className, color = 'info', icon: Icon, onDismiss, rounded = true, theme: customTheme = {}, withBorderAccent, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.alert, customTheme);
    return ((0, jsx_runtime_1.jsxs)("div", { className: (0, classnames_1.default)(theme.base, theme.color[color], rounded && theme.rounded, withBorderAccent && theme.borderAccent, className), role: "alert", ...props, children: [(0, jsx_runtime_1.jsxs)("div", { className: theme.wrapper, "data-testid": "flowbite-alert-wrapper", children: [Icon && (0, jsx_runtime_1.jsx)(Icon, { className: theme.icon, "data-testid": "flowbite-alert-icon" }), (0, jsx_runtime_1.jsx)("div", { children: children }), typeof onDismiss === 'function' && ((0, jsx_runtime_1.jsx)("button", { "aria-label": "Dismiss", className: (0, classnames_1.default)(theme.closeButton.base, theme.closeButton.color[color]), onClick: onDismiss, type: "button", children: (0, jsx_runtime_1.jsx)(hi_1.HiX, { "aria-hidden": true, className: theme.closeButton.icon }) }))] }), additionalContent && (0, jsx_runtime_1.jsx)("div", { children: additionalContent })] }));
};
exports.Alert = Alert;
