"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListGroupItem = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const ListGroupItem = ({ active: isActive, children, className, href, icon: Icon, onClick, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.listGroup.item, customTheme);
    const isLink = typeof href !== 'undefined';
    const Component = isLink ? 'a' : 'button';
    return ((0, jsx_runtime_1.jsx)("li", { className: (0, classnames_1.default)(theme.base, className), children: (0, jsx_runtime_1.jsxs)(Component, { href: href, onClick: onClick, type: isLink ? undefined : 'button', className: (0, classnames_1.default)(theme.link.active[isActive ? 'on' : 'off'], theme.link.base, theme.link.href[isLink ? 'on' : 'off']), ...props, children: [Icon && (0, jsx_runtime_1.jsx)(Icon, { "aria-hidden": true, "data-testid": "flowbite-list-group-item-icon", className: theme.link.icon }), children] }) }));
};
exports.ListGroupItem = ListGroupItem;
