"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NavbarToggle = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const go_1 = require("react-icons/go");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const NavbarContext_1 = require("./NavbarContext");
const NavbarToggle = ({ barIcon: BarIcon = go_1.GoThreeBars, className, theme: customTheme = {}, ...props }) => {
    const { isOpen, setIsOpen } = (0, NavbarContext_1.useNavbarContext)();
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.navbar.toggle, customTheme);
    const handleClick = () => {
        setIsOpen(!isOpen);
    };
    return ((0, jsx_runtime_1.jsxs)("button", { "data-testid": "flowbite-navbar-toggle", onClick: handleClick, className: (0, classnames_1.default)(theme.base, className), ...props, children: [(0, jsx_runtime_1.jsx)("span", { className: "sr-only", children: "Open main menu" }), (0, jsx_runtime_1.jsx)(BarIcon, { "aria-hidden": true, className: theme.icon })] }));
};
exports.NavbarToggle = NavbarToggle;
