"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const PaginationButton = ({ active, children, className, onClick, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.pagination, customTheme);
    return ((0, jsx_runtime_1.jsx)("button", { className: (0, classnames_1.default)({
            [theme.pages.selector.active]: active,
        }, className), onClick: onClick, ...props, children: children }));
};
PaginationButton.displayName = 'Pagination.Button';
exports.default = PaginationButton;
