"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Progress = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const react_1 = require("react");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const Progress = ({ className, color = 'blue', labelProgress = false, labelText = false, progress, progressLabelPosition = 'inside', size = 'md', textLabel = 'progressbar', textLabelPosition = 'inside', theme: customTheme = {}, ...props }) => {
    const id = (0, react_1.useId)();
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.progress, customTheme);
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: (0, jsx_runtime_1.jsxs)("div", { id: id, "aria-label": textLabel, "aria-valuenow": progress, role: "progressbar", ...props, children: [((textLabel && labelText && textLabelPosition === 'outside') ||
                    (progress && labelProgress && progressLabelPosition === 'outside')) && ((0, jsx_runtime_1.jsxs)("div", { className: theme.label, "data-testid": "flowbite-progress-outer-label-container", children: [textLabel && labelText && textLabelPosition === 'outside' && ((0, jsx_runtime_1.jsx)("span", { "data-testid": "flowbite-progress-outer-text-label", children: textLabel })), progress && labelProgress && progressLabelPosition === 'outside' && ((0, jsx_runtime_1.jsxs)("span", { "data-testid": "flowbite-progress-outer-progress-label", children: [progress, "%"] }))] })), (0, jsx_runtime_1.jsx)("div", { className: (0, classnames_1.default)(theme.base, theme.size[size], className), children: (0, jsx_runtime_1.jsxs)("div", { style: { width: `${progress}%` }, className: (0, classnames_1.default)(theme.bar, theme.color[color], theme.size[size]), children: [textLabel && labelText && textLabelPosition === 'inside' && ((0, jsx_runtime_1.jsx)("span", { "data-testid": "flowbite-progress-inner-text-label", children: textLabel })), progress && labelProgress && progressLabelPosition === 'inside' && ((0, jsx_runtime_1.jsxs)("span", { "data-testid": "flowbite-progress-inner-progress-label", children: [progress, "%"] }))] }) })] }) }));
};
exports.Progress = Progress;
