"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimelinePoint = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const Flowbite_1 = require("../Flowbite");
const TimelineContext_1 = require("./TimelineContext");
const TimelinePoint = ({ children, className, icon: Icon, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, Flowbite_1.useTheme)().theme.timeline.item.point, customTheme);
    const { horizontal } = (0, TimelineContext_1.useTimelineContext)();
    return ((0, jsx_runtime_1.jsxs)("div", { "data-testid": "timeline-point", className: (0, classnames_1.default)(horizontal && theme.horizontal, !horizontal && theme.vertical, className), ...props, children: [children, Icon ? ((0, jsx_runtime_1.jsx)("span", { className: (0, classnames_1.default)(theme.marker.icon.wrapper), children: (0, jsx_runtime_1.jsx)(Icon, { "aria-hidden": true, className: (0, classnames_1.default)(theme.marker.icon.base) }) })) : ((0, jsx_runtime_1.jsx)("div", { className: (0, classnames_1.default)(horizontal && theme.marker.base.horizontal, !horizontal && theme.marker.base.vertical) })), horizontal && (0, jsx_runtime_1.jsx)("div", { className: (0, classnames_1.default)(theme.line) })] }));
};
exports.TimelinePoint = TimelinePoint;
