import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from 'classnames';
import { HiX } from 'react-icons/hi';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const Alert = ({ additionalContent, children, className, color = 'info', icon: Icon, onDismiss, rounded = true, theme: customTheme = {}, withBorderAccent, ...props }) => {
    const theme = mergeDeep(useTheme().theme.alert, customTheme);
    return (_jsxs("div", { className: classNames(theme.base, theme.color[color], rounded && theme.rounded, withBorderAccent && theme.borderAccent, className), role: "alert", ...props, children: [_jsxs("div", { className: theme.wrapper, "data-testid": "flowbite-alert-wrapper", children: [Icon && _jsx(Icon, { className: theme.icon, "data-testid": "flowbite-alert-icon" }), _jsx("div", { children: children }), typeof onDismiss === 'function' && (_jsx("button", { "aria-label": "Dismiss", className: classNames(theme.closeButton.base, theme.closeButton.color[color]), onClick: onDismiss, type: "button", children: _jsx(HiX, { "aria-hidden": true, className: theme.closeButton.icon }) }))] }), additionalContent && _jsx("div", { children: additionalContent })] }));
};
