import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { ButtonProps } from '../Button';
export interface FlowbiteButtonGroupTheme {
    base: string;
    position: PositionInButtonGroup;
}
export interface PositionInButtonGroup {
    none: string;
    start: string;
    middle: string;
    end: string;
}
export interface ButtonGroupProps extends ComponentProps<'div'>, PropsWithChildren, Pick<ButtonProps, 'outline' | 'pill'> {
    theme?: DeepPartial<FlowbiteButtonGroupTheme>;
}
declare const ButtonGroup: FC<ButtonGroupProps>;
export default ButtonGroup;
