import type { Placement } from '@floating-ui/core';
import type { ComponentProps, FC, PropsWithChildren, ReactNode } from 'react';
export interface FlowbiteFloatingTheme {
    arrow: FlowbiteFloatingArrowTheme;
    animation: string;
    base: string;
    content: string;
    hidden: string;
    style: {
        auto: string;
        dark: string;
        light: string;
    };
    target: string;
}
export interface FlowbiteFloatingArrowTheme {
    base: string;
    placement: string;
    style: {
        dark: string;
        light: string;
        auto: string;
    };
}
export interface FloatingProps extends PropsWithChildren<Omit<ComponentProps<'div'>, 'style'>> {
    animation?: false | `duration-${number}`;
    arrow?: boolean;
    closeRequestKey?: string;
    content: ReactNode;
    placement?: 'auto' | Placement;
    style?: 'dark' | 'light' | 'auto';
    theme: FlowbiteFloatingTheme;
    trigger?: 'hover' | 'click';
}
/**
 * @see https://floating-ui.com/docs/react-dom-interactions
 */
export declare const Floating: FC<FloatingProps>;
