import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { autoUpdate, safePolygon, useClick, useFloating, useFocus, useHover, useInteractions, useRole, } from '@floating-ui/react';
import classNames from 'classnames';
import { useEffect, useRef, useState } from 'react';
import { getArrowPlacement, getMiddleware, getPlacement } from '../../helpers/floating';
/**
 * @see https://floating-ui.com/docs/react-dom-interactions
 */
export const Floating = ({ animation = 'duration-300', arrow = true, children, className, closeRequestKey, content, placement = 'top', style = 'dark', theme, trigger = 'hover', ...props }) => {
    const arrowRef = useRef(null);
    const [open, setOpen] = useState(false);
    const floatingTooltip = useFloating({
        middleware: getMiddleware({ arrowRef, placement }),
        onOpenChange: setOpen,
        open,
        placement: getPlacement({ placement }),
    });
    const { context, floating, middlewareData: { arrow: { x: arrowX, y: arrowY } = {} }, reference, refs, strategy, update, x, y, } = floatingTooltip;
    const { getFloatingProps, getReferenceProps } = useInteractions([
        useClick(context, { enabled: trigger === 'click' }),
        useFocus(context),
        useHover(context, {
            enabled: trigger === 'hover',
            handleClose: safePolygon(),
        }),
        useRole(context, { role: 'tooltip' }),
    ]);
    useEffect(() => {
        if (refs.reference.current && refs.floating.current && open) {
            return autoUpdate(refs.reference.current, refs.floating.current, update);
        }
    }, [open, refs.floating, refs.reference, update]);
    useEffect(() => {
        if (closeRequestKey !== undefined)
            setOpen(false);
    }, [closeRequestKey]);
    return (_jsxs(_Fragment, { children: [_jsx("div", { className: theme.target, ...getReferenceProps({ ref: reference }), "data-testid": "flowbite-tooltip-target", children: children }), _jsxs("div", { "data-testid": "flowbite-tooltip", ...getFloatingProps({
                    className: classNames(theme.base, animation && `${theme.animation} ${animation}`, !open && theme.hidden, theme.style[style], className),
                    ref: floating,
                    style: {
                        position: strategy,
                        top: y ?? ' ',
                        left: x ?? ' ',
                    },
                    ...props,
                }), children: [_jsx("div", { className: theme.content, children: content }), arrow && (_jsx("div", { className: classNames(theme.arrow.base, {
                            [theme.arrow.style.dark]: style === 'dark',
                            [theme.arrow.style.light]: style === 'light',
                            [theme.arrow.style.auto]: style === 'auto',
                        }), "data-testid": "flowbite-tooltip-arrow", ref: arrowRef, style: {
                            top: arrowY ?? ' ',
                            left: arrowX ?? ' ',
                            right: ' ',
                            bottom: ' ',
                            [getArrowPlacement({ placement: floatingTooltip.placement })]: theme.arrow.placement,
                        }, children: "\u00A0" }))] })] }));
};
