import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect, useMemo } from 'react';
import { mergeDeep } from '../../helpers/mergeDeep';
import windowExists from '../../helpers/window-exists';
import defaultTheme from '../../theme/default';
import { ThemeContext, useTheme, useThemeMode } from './ThemeContext';
export const Flowbite = ({ children, theme = {} }) => {
    const { theme: customTheme = {}, dark } = theme;
    const [mode, setMode, toggleMode] = useThemeMode();
    const mergedTheme = mergeDeep(defaultTheme, customTheme);
    useEffect(() => {
        if (dark) {
            if (setMode != null) {
                setMode('dark');
            }
            if (windowExists()) {
                document.documentElement.classList.add('dark');
            }
        }
        else {
            if (setMode != null) {
                setMode('light');
            }
            if (windowExists()) {
                document.documentElement.classList.remove('dark');
            }
        }
    }, [dark, setMode]);
    const themeContextValue = useMemo(() => ({
        theme: mergedTheme,
        mode,
        toggleMode,
    }), [mode, toggleMode, mergedTheme]);
    return _jsx(ThemeContext.Provider, { value: themeContextValue, children: children });
};
export { useTheme, useThemeMode };
