import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const HelperText = ({ children, className, color = 'default', theme: customTheme = {}, value, ...props }) => {
    const theme = mergeDeep(useTheme().theme.helperText, customTheme);
    return (_jsx("p", { className: classNames(theme.root.base, theme.root.colors[color], className), ...props, children: value ?? children ?? '' }));
};
