import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteStateColors } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteLabelTheme {
    root: FlowbiteLabelRootTheme;
}
export interface FlowbiteLabelRootTheme {
    base: string;
    colors: LabelColors;
    disabled: string;
}
export interface LabelColors extends FlowbiteStateColors {
    [key: string]: string;
    default: string;
}
export interface LabelProps extends PropsWithChildren<Omit<ComponentProps<'label'>, 'color'>> {
    color?: keyof LabelColors;
    disabled?: boolean;
    theme?: DeepPartial<FlowbiteLabelTheme>;
    value?: string;
}
export declare const Label: FC<LabelProps>;
