import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const Label = ({ children, className, color = 'default', disabled = false, theme: customTheme = {}, value, ...props }) => {
    const theme = mergeDeep(useTheme().theme.label, customTheme);
    return (_jsx("label", { className: classNames(theme.root.base, theme.root.colors[color], disabled ?? theme.root.disabled, className), ...props, children: value ?? children ?? '' }));
};
