import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import classNames from 'classnames';
import { useId } from 'react';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
export const Progress = ({ className, color = 'blue', labelProgress = false, labelText = false, progress, progressLabelPosition = 'inside', size = 'md', textLabel = 'progressbar', textLabelPosition = 'inside', theme: customTheme = {}, ...props }) => {
    const id = useId();
    const theme = mergeDeep(useTheme().theme.progress, customTheme);
    return (_jsx(_Fragment, { children: _jsxs("div", { id: id, "aria-label": textLabel, "aria-valuenow": progress, role: "progressbar", ...props, children: [((textLabel && labelText && textLabelPosition === 'outside') ||
                    (progress && labelProgress && progressLabelPosition === 'outside')) && (_jsxs("div", { className: theme.label, "data-testid": "flowbite-progress-outer-label-container", children: [textLabel && labelText && textLabelPosition === 'outside' && (_jsx("span", { "data-testid": "flowbite-progress-outer-text-label", children: textLabel })), progress && labelProgress && progressLabelPosition === 'outside' && (_jsxs("span", { "data-testid": "flowbite-progress-outer-progress-label", children: [progress, "%"] }))] })), _jsx("div", { className: classNames(theme.base, theme.size[size], className), children: _jsxs("div", { style: { width: `${progress}%` }, className: classNames(theme.bar, theme.color[color], theme.size[size]), children: [textLabel && labelText && textLabelPosition === 'inside' && (_jsx("span", { "data-testid": "flowbite-progress-inner-text-label", children: textLabel })), progress && labelProgress && progressLabelPosition === 'inside' && (_jsxs("span", { "data-testid": "flowbite-progress-inner-progress-label", children: [progress, "%"] }))] }) })] }) }));
};
