import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteRatingAdvancedTheme } from './RatingAdvanced';
import type { FlowbiteRatingStarTheme, FlowbiteStarSizes } from './RatingStar';
export interface FlowbiteRatingTheme {
    root: {
        base: string;
    };
    star: FlowbiteRatingStarTheme;
    advanced: FlowbiteRatingAdvancedTheme;
}
export interface RatingProps extends PropsWithChildren<ComponentProps<'div'>> {
    size?: keyof FlowbiteStarSizes;
    theme?: DeepPartial<FlowbiteRatingTheme>;
}
export declare const Rating: FC<RatingProps> & {
    Star: FC<import("./RatingStar").RatingStarProps>;
    Advanced: FC<import("./RatingAdvanced").RatingAdvancedProps>;
};
