import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteBoolean } from '../Flowbite/FlowbiteTheme';
import type { SidebarItemProps } from './SidebarItem';
export interface FlowbiteSidebarCollapseTheme {
    button: string;
    icon: {
        base: string;
        open: FlowbiteBoolean;
    };
    label: {
        base: string;
        icon: string;
    };
    list: string;
}
export interface SidebarCollapseProps extends PropsWithChildren, Pick<SidebarItemProps, 'active' | 'as' | 'href' | 'icon' | 'label' | 'labelColor'>, ComponentProps<'button'> {
    onClick?: ComponentProps<'button'>['onClick'];
    open?: boolean;
    theme?: DeepPartial<FlowbiteSidebarCollapseTheme>;
}
declare const SidebarCollapse: FC<SidebarCollapseProps>;
export default SidebarCollapse;
