import type { ComponentProps, ElementType, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteColors } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteSidebarItemTheme {
    active: string;
    base: string;
    collapsed: {
        insideCollapse: string;
        noIcon: string;
    };
    content: {
        base: string;
    };
    icon: {
        base: string;
        active: string;
    };
    label: string;
}
export interface SidebarItemProps extends PropsWithChildren, Omit<ComponentProps<'div'>, 'ref'>, Record<string, unknown> {
    active?: boolean;
    as?: ElementType;
    href?: string;
    icon?: FC<ComponentProps<'svg'>>;
    label?: string;
    labelColor?: keyof SidebarItemLabelColors;
    theme?: DeepPartial<FlowbiteSidebarItemTheme>;
}
export interface SidebarItemLabelColors extends Pick<FlowbiteColors, 'gray'> {
    [key: string]: string;
}
declare const SidebarItem: import("react").ForwardRefExoticComponent<Omit<SidebarItemProps, "ref"> & import("react").RefAttributes<Element>>;
export default SidebarItem;
