import type { ComponentProps, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteBoolean } from '../Flowbite/FlowbiteTheme';
import type { TabItemProps } from './TabItem';
export interface FlowbiteTabTheme {
    base: string;
    tablist: {
        base: string;
        styles: TabStyles;
        tabitem: {
            base: string;
            styles: TabStyleItem<TabStyles>;
            icon: string;
        };
    };
    tabpanel: string;
}
export interface TabStyles {
    default: string;
    fullWidth: string;
    pills: string;
    underline: string;
}
export interface TabStyleItemProps {
    base: string;
    active: FlowbiteBoolean;
}
export type TabStyleItem<Type> = {
    [K in keyof Type]: TabStyleItemProps;
};
export type TabItemStatus = 'active' | 'notActive';
export interface TabsProps extends PropsWithChildren, Omit<ComponentProps<'div'>, 'ref' | 'style'> {
    onActiveTabChange?: (activeTab: number) => void;
    style?: keyof TabStyles;
    theme?: DeepPartial<FlowbiteTabTheme>;
}
export interface TabsRef {
    setActiveTab: (activeTab: number) => void;
}
export declare const TabsComponent: import("react").ForwardRefExoticComponent<TabsProps & import("react").RefAttributes<TabsRef>>;
export declare const Tabs: {
    Group: import("react").ForwardRefExoticComponent<TabsProps & import("react").RefAttributes<TabsRef>>;
    Item: import("react").FC<TabItemProps>;
};
