import type { ComponentProps, FC, PropsWithChildren } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteTableCellTheme } from './TableCell';
import type { TableContextType } from './TableContext';
import type { FlowbiteTableHeadTheme } from './TableHead';
import type { FlowbiteTableRowTheme } from './TableRow';
export interface FlowbiteTableTheme {
    root: FlowbiteTableRootTheme;
    cell: FlowbiteTableCellTheme;
    head: FlowbiteTableHeadTheme;
    row: FlowbiteTableRowTheme;
}
export interface FlowbiteTableRootTheme {
    base: string;
    wrapper: string;
}
export interface TableProps extends PropsWithChildren, ComponentProps<'table'>, TableContextType {
    theme?: DeepPartial<FlowbiteTableTheme>;
}
export declare const Table: FC<TableProps> & {
    Head: FC<import("./TableHead").TableHeadProps>;
    Body: FC<import("./TableBody").TableBodyProps>;
    Row: FC<import("./TableRow").TableRowProps>;
    Cell: FC<import("./TableCell").TableCellProps>;
    HeadCell: FC<import("./TableHeadCell").TableHeadCellProps>;
};
