/// <reference types="react" />
import { AppData } from "@remix-run/server-runtime";
import type { Thing, WithContext } from "schema-dts";
import { HandleConventionArguments } from "./handle-conventions";
export declare type StructuredDatum<StructuredDataSchema extends Thing> = WithContext<StructuredDataSchema>;
/**
 * A convenience type for `export let handle =` to ensure the correct `handle` structure is used.
 *
 * @example
 * // This route uses the data to render structured data (e.g. BreadcrumbList and BlogPosting)
 * export let handle: HandleStructuredData<LoaderData> = {
 *    structuredData({ id, data, params }) => {
 *       return [{...}]
 *    },
 * };
 */
export declare type HandleStructuredData<LoaderData extends AppData = AppData, StructuredDataSchema extends Thing = Thing> = {
    structuredData: StructuredDataFunction<LoaderData, StructuredDataSchema>;
};
export interface StructuredDataFunction<Data extends AppData = AppData, StructuredDataSchema extends Thing = Thing> {
    (args: HandleConventionArguments<Data>): StructuredDatum<StructuredDataSchema> | StructuredDatum<StructuredDataSchema>[] | null;
}
/**
 * Render "application/ld+json" script tags for structured data (https://developers.google.com/search/docs/advanced/structured-data/intro-structured-data)
 * @example
 * // This route uses the data to render structured data (e.g. BreadcrumbList and BlogPosting)
 * export let handle: HandleStructuredData<LoaderData, BlogPosting> = {
 *    structuredData({ data }) {
 *      let { post } = data;
 *
 *      return {
 *        '@context': 'https://schema.org',
 *        '@type': 'BlogPosting',
 *        datePublished: post.published,
 *        mainEntityOfPage: {
 *          '@type': 'WebPage',
 *          '@id': post.postUrl,
 *        },
 *        image: post.featuredImage,
 *        author: {
 *          '@type': 'Person',
 *          name: post.authorName,
 *        },
 *      };
 *    },
 * };
 */
export declare function StructuredData(): JSX.Element | null;
