import { useEffect, useState } from "react";
/**
 * Subscribe to an event source and return the latest event.
 * @param url The URL of the event source to connect to
 * @param options The options to pass to the EventSource constructor
 * @returns The last event received from the server
 */
export function useEventSource(url, { event = "message", init } = {}) {
    const [data, setData] = useState(null);
    useEffect(() => {
        const eventSource = new EventSource(url, init);
        eventSource.addEventListener(event !== null && event !== void 0 ? event : "message", handler);
        // rest data if dependencies change
        setData(null);
        function handler(event) {
            setData(event.data || "UNKNOWN_EVENT_DATA");
        }
        return () => {
            eventSource.removeEventListener(event !== null && event !== void 0 ? event : "message", handler);
            eventSource.close();
        };
    }, [url, event, init]);
    return data;
}
