import Contacto1 from "../../public/assets/img/contact-icon01.webp"
import Contacto2 from "../../public/assets/img/contact-icon02.webp"
import ReCAPTCHA from 'react-google-recaptcha'
import { Button } from "flowbite-react"
import { useState } from "react"
import Swal from "sweetalert2"
import { validateEmail } from "~/helpers/functions"

//Captcha Public 6Lf2qyclAAAAAIrIV8dfnP1iMxLkbOhGoK2dU68a
//Captcha Private 6Lf2qyclAAAAAFvIbRvc0mSl7RDPkJd5o-3lTyP5  

const Contacto = ({baseUrlApi}) => {
    const [ nombre, setNombre ] = useState("")
    const [ correo, setCorreo ] = useState("")
    const [ telefono, setTelefono ] = useState("")
    const [ ciudad, setCiudad ] = useState("")
    const [ mensaje, setMensaje ] = useState("")
    const [ captcha, setCaptcha ] = useState("")
    const [ enabled, setEnabled ] = useState(false)
    const [ loading, setLoading ] = useState("hidden")

    const handleSubmit = async e => {
        e.preventDefault()
        setEnabled(true)
        setLoading("")
        if ( nombre === "" ) {
            setEnabled(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Nombre' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( correo === "" ) {
            setEnabled(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Correo electrónico' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( !validateEmail(correo) ) {
            setEnabled(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Correo electrónico' no es válido",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( telefono === "" ) {
            setEnabled(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Teléfono' está vacío",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( telefono.length < 10 ) {
            setEnabled(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Teléfono' debe contener 10 dígitos",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( ciudad.length === "" ) {
            setEnabled(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Ciudad' debe contener 10 dígitos",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if( mensaje.length === 0 ) {
            setEnabled(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "El campo 'Mensaje' debe contener 10 dígitos",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else if ( captcha === "" ) {
            setEnabled(false)
            setLoading("hidden")
            Swal.fire({
                title: "<h2>¡Validación!</h2>",
                html: "Comprueba que no eres un robot",
                icon: 'warning',
                confirmButtonText: ' Cerrar ',
                confirmButtonColor: '#eabb2e',
            })
        } else {
            const dataPost = {
                nombre,correo,telefono,ciudad,mensaje,captcha
            }
            const respuesta = await fetch(`${baseUrlApi}/send/contacto`, {
                method: "POST",
                body: JSON.stringify(dataPost),
                headers: {"Content-type": "application/json; charset=UTF-8"}

            })
            const res = await respuesta.json()
            if ( res.error ) {
                setEnabled(false)
                setLoading("hidden")
                Swal.fire({
                    title: "<h2>¡Validación!</h2>",
                    html: res.message,
                    icon: 'warning',
                    confirmButtonText: ' Cerrar ',
                    confirmButtonColor: '#eabb2e',
                })
            } else {
                setEnabled(false)
                setLoading("hidden")
                window.grecaptcha.reset()
                Swal.fire({
                    title: "<h2>¡Excelente!</h2>",
                    html: res.message,
                    icon: 'success',
                    confirmButtonText: ' Cerrar ',
                    confirmButtonColor: '#eabb2e',
                })

                setNombre("")
                setCorreo("")
                setTelefono("")
                setCiudad("")
                setMensaje("")
                
            }
            setEnabled(false)
            setLoading("hidden")
        }
    }

    const onChange = c => {
        setCaptcha(c)
        setErrorCaptcha("")
        setDisabled(false)
    }

    return (
        <section className="bg-white py-20">
            <form onSubmit={e => handleSubmit(e)}>
                <div className="container w-10/12 mx-auto lg:flex">
                    <div className="lg:w-3/12 flex flex-col justify-center items-start mb-3">
                        <div className="flex mb-5">
                            <img className="w-14" src={Contacto1} alt="Contacto Icono" />
                            <img className="w-14" src={Contacto2} alt="Contacto Icono" />
                        </div>
                        <p className="text-2xl text-eBlack font-MontserratSemiBold mb-2">¿Tienes alguna duda o sugerencia?</p>
                        <p className="text-3xl text-eBlue font-MontserratSemiBold mb-5">CONTÁCTANOS</p>
                        <p className="text-lg">Nuestro equipo te dará seguimiento a la brevedad.</p>
                    </div>
                    <div className="lg:w-6/12 lg:mx-5 mb-3">
                        <input 
                            value={nombre}
                            onChange={e => setNombre(e.target.value)} 
                            className="w-full mb-2 bg-eLightGray border-none rounded-md" 
                            type="text" 
                            placeholder="* Nombre completo" />
                        <input
                            value={correo}
                            onChange={e => setCorreo(e.target.value)}  
                            className="w-full my-2 bg-eLightGray border-none rounded-md" 
                            type="text" 
                            placeholder="* Correo electrónico" />
                        <div className="lg:flex">
                            <input 
                                value={telefono}
                                onChange={e => setTelefono(e.target.value)}  
                                name="telefono" 
                                className="w-full my-2 lg:mr-2 bg-eLightGray border-none rounded-md" 
                                type="text" 
                                placeholder="* Teléfono" />
                            <input 
                                value={ciudad}
                                onChange={e => setCiudad(e.target.value)}  
                                name="ciudad" 
                                className="w-full my-2 lg:ml-2 bg-eLightGray border-none rounded-md" 
                                type="text" 
                                placeholder="* Ciudad" />
                        </div>
                        <textarea 
                            value={mensaje}
                            onChange={e => setMensaje(e.target.value)}
                            className="w-full mt-2 bg-eLightGray border-none rounded-md" 
                            rows="5" 
                            placeholder="* Deja tu comentario"></textarea>
                    </div>
                    <div className="w-3/12 flex flex-col justify-end items-start">
                        <ReCAPTCHA 
                            className="mb-3"
                            sitekey='6Lf2qyclAAAAAIrIV8dfnP1iMxLkbOhGoK2dU68a'
                            onChange={onChange}
                        />
                        <Button 
                            type="submit" 
                            disabled={enabled} 
                            className="flex text-eBlack font-MontserratMedium !rounded-full bg-eYellow px-10"
                        >
                            Enviar
                            <span className={`${loading} relative flex h-3 w-3`}>
                                <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-white opacity-75"></span>
                                <span className="relative inline-flex rounded-full h-3 w-3 bg-white"></span>
                            </span>
                        </Button>
                    </div>
                </div>
            </form>
        </section>
    )
}

export default Contacto
