import MejoresProductos from "./modal/mejores-productos"
import Garantia from "./modal/garantia"
import Instalacion from "./modal/instalacion"
import Pago from "./modal/pago"
import Cobertura from "./modal/cobertura"
import LogoServicio from "../../public/assets/img/logo-benef.webp"
import GoIconServicio from "../../public/assets/img/go-icon-blue.webp"
import IconServicio1 from "../../public/assets/img/icon01.webp"
import IconServicio2 from "../../public/assets/img/icon02.webp"
import IconServicio3 from "../../public/assets/img/icon03.webp"
import IconServicio4 from "../../public/assets/img/icon04.webp"
import IconServicio5 from "../../public/assets/img/icon05.webp"

const SatisfaccionGarantizada = () => {
    return (
        <section className="bg-eLightGray py-10">
            <div className="container w-10/12 mx-auto">
                <div className="flex flex-col lg:flex-row justify-center items-center mb-10">
                    <p className="text-3xl font-MontserratBold text-center lg:text-start mr-5">Servicio con <span className="text-eBlue">satisfacción garantizada</span></p>
                    <img src={LogoServicio} alt="Eversafe Logo" className="w-52" />
                </div>

                <MejoresProductos />
                <Garantia />
                <Instalacion />
                <Pago />
                <Cobertura />

                <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-5">
                    <div className="flex flex-col justify-between items-center lg:p-10 lg:h-96">
                        <img src={IconServicio1} alt="Contamos con los mejores productos" />
                        <p className="text-center text-md">Contamos <br /> con los mejores productos</p>
                        <button className="flex justify-end items-center" data-te-toggle="modal" data-te-target="#mejores" data-te-ripple-init>
                            <p className="text-eBlue text-sm mr-2">Conoce más</p>
                            <img src={GoIconServicio} alt="Conoce más sobre nuetros productos" className="h-3 mt-1" />
                        </button>
                    </div>
                    <div className="flex flex-col justify-between items-center lg:p-10 lg:h-96">
                        <img src={IconServicio2} alt="Garantía incluida con tu compra" />
                        <p className="text-center text-md">Garantía <br /> incluida con <br /> tu compra</p>
                        <button className="flex justify-end items-center" data-te-toggle="modal" data-te-target="#garantia" data-te-ripple-init>
                            <p className="text-eBlue text-sm mr-2">Conoce más</p>
                            <img src={GoIconServicio} alt="Conoce más sobre nuetros productos" className="h-3 mt-1" />
                        </button>
                    </div>
                    <div className="flex flex-col justify-between items-center lg:p-10 lg:h-96">
                        <img src={IconServicio3} alt="Instalación y mantenimiento completo" />
                        <p className="text-center text-md">Instalación y <br /> mantenimiento <br /> completo</p>
                        <button className="flex justify-end items-center" data-te-toggle="modal" data-te-target="#instalacion" data-te-ripple-init>
                            <p className="text-eBlue text-sm mr-2">Conoce más</p>
                            <img src={GoIconServicio} alt="Conoce más sobre nuetros productos" className="h-3 mt-1" />
                        </button>
                    </div>
                    <div className="flex flex-col justify-between items-center lg:p-10 lg:h-96">
                        <img src={IconServicio4} alt="Aceptamos todos los métodos de pago" />
                        <p className="text-center text-md">Aceptamos <br /> todos los métodos <br /> de pago</p>
                        <button className="flex justify-end items-center" data-te-toggle="modal" data-te-target="#pago" data-te-ripple-init>
                            <p className="text-eBlue text-sm mr-2">Conoce más</p>
                            <img src={GoIconServicio} alt="Conoce más sobre nuetros productos" className="h-3 mt-1" />
                        </button>
                    </div>
                    <div className="flex flex-col justify-between items-center lg:p-10 lg:h-96">
                        <img src={IconServicio5} alt="Amplia cobertura de envíos" />
                        <p className="text-center text-md">Amplia <br /> cobertura <br /> de envíos</p>
                        <button className="flex justify-end items-center" data-te-toggle="modal" data-te-target="#cobertura" data-te-ripple-init>
                            <p className="text-eBlue text-sm mr-2">Conoce más</p>
                            <img src={GoIconServicio} alt="Conoce más sobre nuetros productos" className="h-3 mt-1" />
                        </button>
                    </div>
                </div>
            </div>
        </section>
    )
}

export default SatisfaccionGarantizada