import type { RemixConfig } from "../config";
import type { CompileOptions } from "./options";
import type { CompileResult } from "./remixCompiler";
export type WatchOptions = Partial<CompileOptions> & {
    reloadConfig?(root: string): Promise<RemixConfig>;
    onRebuildStart?(): void;
    onRebuildFinish?(durationMs: number, result?: CompileResult): void;
    onFileCreated?(file: string): void;
    onFileChanged?(file: string): void;
    onFileDeleted?(file: string): void;
    onInitialBuild?(durationMs: number, result?: CompileResult): void;
};
export declare function watch(config: RemixConfig, { mode, liveReloadPort, target, sourcemap, reloadConfig, onWarning, onCompileFailure, onRebuildStart, onRebuildFinish, onFileCreated, onFileChanged, onFileDeleted, onInitialBuild, }?: WatchOptions): Promise<() => Promise<void>>;
