"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Badge = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const Badge = ({ children, color = 'info', href, icon: Icon, size = 'xs', className, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.badge, customTheme);
    const Content = () => ((0, jsx_runtime_1.jsxs)("span", { className: (0, classnames_1.default)(theme.root.base, theme.root.color[color], theme.icon[Icon ? 'on' : 'off'], theme.root.size[size], className), "data-testid": "flowbite-badge", ...props, children: [Icon && (0, jsx_runtime_1.jsx)(Icon, { "aria-hidden": true, className: theme.icon.size[size], "data-testid": "flowbite-badge-icon" }), children && (0, jsx_runtime_1.jsx)("span", { children: children })] }));
    return href ? ((0, jsx_runtime_1.jsx)("a", { className: theme.root.href, href: href, children: (0, jsx_runtime_1.jsx)(Content, {}) })) : ((0, jsx_runtime_1.jsx)(Content, {}));
};
exports.Badge = Badge;
