"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FooterLink = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const FooterLink = ({ as: Component = 'a', children, className, href, theme: customTheme = {}, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.footer.groupLink.link, customTheme);
    return ((0, jsx_runtime_1.jsx)("li", { className: (0, classnames_1.default)(theme.base, className), children: (0, jsx_runtime_1.jsx)(Component, { href: href, className: theme.href, ...props, children: children }) }));
};
exports.FooterLink = FooterLink;
