"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pagination = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const hi_1 = require("react-icons/hi");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const range_1 = __importDefault(require("../../helpers/range"));
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const PaginationButton_1 = __importDefault(require("./PaginationButton"));
const PaginationComponent = ({ className, currentPage, layout = 'pagination', nextLabel = 'Next', onPageChange, previousLabel = 'Previous', renderPaginationButton = (props) => (0, jsx_runtime_1.jsx)(PaginationButton_1.default, { ...props }), showIcons: showIcon = false, theme: customTheme = {}, totalPages, ...props }) => {
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.pagination, customTheme);
    const firstPage = Math.max(1, currentPage - 3);
    const lastPage = Math.min(currentPage + 3, totalPages);
    const goToNextPage = () => {
        onPageChange(Math.min(currentPage + 1, totalPages));
    };
    const goToPreviousPage = () => {
        onPageChange(Math.max(currentPage - 1, 1));
    };
    return ((0, jsx_runtime_1.jsxs)("nav", { className: (0, classnames_1.default)(theme.base, className), ...props, children: [layout === 'table' && ((0, jsx_runtime_1.jsxs)("div", { className: theme.layout.table.base, children: ["Showing ", (0, jsx_runtime_1.jsx)("span", { className: theme.layout.table.span, children: firstPage }), " to\u00A0", (0, jsx_runtime_1.jsx)("span", { className: theme.layout.table.span, children: lastPage }), " of\u00A0", (0, jsx_runtime_1.jsx)("span", { className: theme.layout.table.span, children: totalPages }), " Entries"] })), (0, jsx_runtime_1.jsxs)("ul", { className: theme.pages.base, children: [(0, jsx_runtime_1.jsx)("li", { children: renderPaginationButton({
                            className: (0, classnames_1.default)((0, classnames_1.default)(theme.pages.previous.base, showIcon && theme.pages.showIcon)),
                            onClick: goToPreviousPage,
                            children: ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [showIcon && (0, jsx_runtime_1.jsx)(hi_1.HiChevronLeft, { "aria-hidden": true, className: theme.pages.previous.icon }), previousLabel] })),
                        }) }), layout === 'pagination' &&
                        (0, range_1.default)(firstPage, lastPage).map((page) => ((0, jsx_runtime_1.jsx)("li", { "aria-current": page === currentPage ? 'page' : undefined, children: renderPaginationButton({
                                className: (0, classnames_1.default)(theme.pages.selector.base, {
                                    [theme.pages.selector.active]: currentPage === page,
                                }),
                                active: page === currentPage,
                                onClick: () => onPageChange(page),
                                children: page,
                            }) }, page))), (0, jsx_runtime_1.jsx)("li", { children: renderPaginationButton({
                            className: (0, classnames_1.default)(theme.pages.next.base, showIcon && theme.pages.showIcon),
                            onClick: goToNextPage,
                            children: ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [nextLabel, showIcon && (0, jsx_runtime_1.jsx)(hi_1.HiChevronRight, { "aria-hidden": true, className: theme.pages.next.icon })] })),
                        }) })] })] }));
};
PaginationComponent.displayName = 'Pagination';
exports.Pagination = Object.assign(PaginationComponent, {
    Button: PaginationButton_1.default,
});
