"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const classnames_1 = __importDefault(require("classnames"));
const react_1 = require("react");
const mergeDeep_1 = require("../../helpers/mergeDeep");
const ThemeContext_1 = require("../Flowbite/ThemeContext");
const SidebarContext_1 = require("./SidebarContext");
const SidebarLogo = ({ children, className, href, img, imgAlt = '', theme: customTheme = {}, ...props }) => {
    const id = (0, react_1.useId)();
    const { isCollapsed } = (0, SidebarContext_1.useSidebarContext)();
    const theme = (0, mergeDeep_1.mergeDeep)((0, ThemeContext_1.useTheme)().theme.sidebar.logo, customTheme);
    return ((0, jsx_runtime_1.jsxs)("a", { "aria-labelledby": `flowbite-sidebar-logo-${id}`, href: href, className: (0, classnames_1.default)(theme.base, className), ...props, children: [(0, jsx_runtime_1.jsx)("img", { alt: imgAlt, src: img, className: theme.img }), (0, jsx_runtime_1.jsx)("span", { className: theme.collapsed[isCollapsed ? 'on' : 'off'], id: `flowbite-sidebar-logo-${id}`, children: children })] }));
};
SidebarLogo.displayName = 'Sidebar.Logo';
exports.default = SidebarLogo;
