import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import classNames from 'classnames';
import { HiChevronLeft, HiChevronRight } from 'react-icons/hi';
import { mergeDeep } from '../../helpers/mergeDeep';
import range from '../../helpers/range';
import { useTheme } from '../Flowbite/ThemeContext';
import PaginationButton from './PaginationButton';
const PaginationComponent = ({ className, currentPage, layout = 'pagination', nextLabel = 'Next', onPageChange, previousLabel = 'Previous', renderPaginationButton = (props) => _jsx(PaginationButton, { ...props }), showIcons: showIcon = false, theme: customTheme = {}, totalPages, ...props }) => {
    const theme = mergeDeep(useTheme().theme.pagination, customTheme);
    const firstPage = Math.max(1, currentPage - 3);
    const lastPage = Math.min(currentPage + 3, totalPages);
    const goToNextPage = () => {
        onPageChange(Math.min(currentPage + 1, totalPages));
    };
    const goToPreviousPage = () => {
        onPageChange(Math.max(currentPage - 1, 1));
    };
    return (_jsxs("nav", { className: classNames(theme.base, className), ...props, children: [layout === 'table' && (_jsxs("div", { className: theme.layout.table.base, children: ["Showing ", _jsx("span", { className: theme.layout.table.span, children: firstPage }), " to\u00A0", _jsx("span", { className: theme.layout.table.span, children: lastPage }), " of\u00A0", _jsx("span", { className: theme.layout.table.span, children: totalPages }), " Entries"] })), _jsxs("ul", { className: theme.pages.base, children: [_jsx("li", { children: renderPaginationButton({
                            className: classNames(classNames(theme.pages.previous.base, showIcon && theme.pages.showIcon)),
                            onClick: goToPreviousPage,
                            children: (_jsxs(_Fragment, { children: [showIcon && _jsx(HiChevronLeft, { "aria-hidden": true, className: theme.pages.previous.icon }), previousLabel] })),
                        }) }), layout === 'pagination' &&
                        range(firstPage, lastPage).map((page) => (_jsx("li", { "aria-current": page === currentPage ? 'page' : undefined, children: renderPaginationButton({
                                className: classNames(theme.pages.selector.base, {
                                    [theme.pages.selector.active]: currentPage === page,
                                }),
                                active: page === currentPage,
                                onClick: () => onPageChange(page),
                                children: page,
                            }) }, page))), _jsx("li", { children: renderPaginationButton({
                            className: classNames(theme.pages.next.base, showIcon && theme.pages.showIcon),
                            onClick: goToNextPage,
                            children: (_jsxs(_Fragment, { children: [nextLabel, showIcon && _jsx(HiChevronRight, { "aria-hidden": true, className: theme.pages.next.icon })] })),
                        }) })] })] }));
};
PaginationComponent.displayName = 'Pagination';
export const Pagination = Object.assign(PaginationComponent, {
    Button: PaginationButton,
});
