import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from 'classnames';
import { useId } from 'react';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite/ThemeContext';
import { useSidebarContext } from './SidebarContext';
const SidebarLogo = ({ children, className, href, img, imgAlt = '', theme: customTheme = {}, ...props }) => {
    const id = useId();
    const { isCollapsed } = useSidebarContext();
    const theme = mergeDeep(useTheme().theme.sidebar.logo, customTheme);
    return (_jsxs("a", { "aria-labelledby": `flowbite-sidebar-logo-${id}`, href: href, className: classNames(theme.base, className), ...props, children: [_jsx("img", { alt: imgAlt, src: img, className: theme.img }), _jsx("span", { className: theme.collapsed[isCollapsed ? 'on' : 'off'], id: `flowbite-sidebar-logo-${id}`, children: children })] }));
};
SidebarLogo.displayName = 'Sidebar.Logo';
export default SidebarLogo;
