import { jsx as _jsx } from "react/jsx-runtime";
import classNames from 'classnames';
import { mergeDeep } from '../../helpers/mergeDeep';
import { useTheme } from '../Flowbite';
export const TableHead = ({ children, className, theme: customTheme = {}, ...props }) => {
    const theme = mergeDeep(useTheme().theme.table, customTheme);
    return (_jsx("thead", { className: classNames(theme.head.base, className), ...props, children: _jsx("tr", { children: children }) }));
};
