import type { ComponentProps, FC } from 'react';
import type { DeepPartial } from '..';
import type { FlowbiteBoolean, FlowbiteColors } from '../Flowbite/FlowbiteTheme';
export interface FlowbiteToggleSwitchTheme {
    root: FlowbiteToggleSwitchRootTheme;
    toggle: FlowbiteToggleSwitchToggleTheme;
}
export interface FlowbiteToggleSwitchRootTheme {
    base: string;
    active: FlowbiteBoolean;
    label: string;
}
export interface FlowbiteToggleSwitchToggleTheme {
    base: string;
    checked: FlowbiteBoolean & {
        color: FlowbiteColors;
    };
}
export type ToggleSwitchProps = Omit<ComponentProps<'button'>, 'onChange'> & {
    checked: boolean;
    color?: FlowbiteColors;
    label: string;
    onChange: (checked: boolean) => void;
    theme?: DeepPartial<FlowbiteToggleSwitchTheme>;
};
export declare const ToggleSwitch: FC<ToggleSwitchProps>;
