import type { Locales } from "../server/get-client-locales";
/**
 * Get the locales returned by the loader of the root route.
 *
 * This is useful to return the locales of the user once in the root and access
 * it everywhere in the UI without having to pass it as a prop or create a
 * custom context object.
 *
 * @example
 * // in the root loader
 * export async function loader({ request }: LoaderArgs) {
 *   let locales = getClientLocales(request);
 *   return json({ locales });
 * }
 * // in any route (including root!)
 * export default function Component() {
 *   let locales = useLocales();
 *   let date = new Date();
 *   let dateTime = date.toISOString;
 *   let formattedDate = date.toLocaleDateString(locales, options)
 *   return <time dateTime={dateTime}>{formattedDate}</time>
 * }
 */
export declare function useLocales(): Locales;
