export async function rollingCookie(cookie, request, responseHeaders) {
    let value = await cookie.parse(responseHeaders.get("Set-Cookie"));
    if (value !== null)
        return;
    value = await cookie.parse(request.headers.get("Cookie"));
    if (!value)
        return;
    responseHeaders.append("Set-Cookie", await cookie.serialize(value));
}
