"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.jsonHash = void 0;
const server_runtime_1 = require("@remix-run/server-runtime");
async function jsonHash(input, init) {
    let result = {};
    let resolvedResults = await Promise.all(Object.entries(input).map(async ([key, value]) => {
        if (value instanceof Function)
            value = value();
        if (value instanceof Promise)
            value = await value;
        return [key, value];
    }));
    for (let [key, value] of resolvedResults) {
        result[key] =
            value;
    }
    return (0, server_runtime_1.json)(result, init);
}
exports.jsonHash = jsonHash;
