"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.namedAction = void 0;
async function namedAction(input, actions) {
    let name = await getActionName(input);
    if (name && name in actions) {
        return actions[name]();
    }
    if (name === null && "default" in actions) {
        return actions["default"]();
    }
    if (name === null)
        throw new ReferenceError("Action name not found");
    throw new ReferenceError(`Action "${name}" not found`);
}
exports.namedAction = namedAction;
async function getActionName(input) {
    if (input instanceof Request) {
        let actionName = findNameInURL(new URL(input.url).searchParams);
        if (actionName)
            return actionName;
        return findNameInFormData(await input.clone().formData());
    }
    if (input instanceof URL) {
        return findNameInURL(input.searchParams);
    }
    if (input instanceof URLSearchParams) {
        return findNameInURL(input);
    }
    if (input instanceof FormData) {
        return findNameInFormData(input);
    }
    return null;
}
function findNameInURL(searchParams) {
    for (let key of searchParams.keys()) {
        if (key.startsWith("/"))
            return key.slice(1);
    }
    let actionName = searchParams.get("intent");
    if (typeof actionName === "string")
        return actionName;
    actionName = searchParams.get("action");
    if (typeof actionName === "string")
        return actionName;
    actionName = searchParams.get("_action");
    if (typeof actionName === "string")
        return actionName;
    return null;
}
function findNameInFormData(formData) {
    for (let key of formData.keys()) {
        if (key.startsWith("/"))
            return key.slice(1);
    }
    let actionName = formData.get("intent");
    if (typeof actionName === "string")
        return actionName;
    actionName = formData.get("action");
    if (typeof actionName === "string")
        return actionName;
    actionName = formData.get("_action");
    if (typeof actionName === "string")
        return actionName;
    return null;
}
