import { Link, useOutletContext } from "@remix-run/react"
import { useEffect } from "react"
import IconFin from "../../public/assets/img/icon-fin.webp"
import LogoEversafe from "../../public/assets/img/logo-benef.webp"

const CompraFinalizada = () => {
    const { carrito, setCarrito, carritoMedida, setCarritoMedida } = useOutletContext()
    useEffect(() => {
        setCarrito([])
        setCarritoMedida([])
        if (typeof window !== 'undefined') {
            localStorage.setItem('carrito', JSON.stringify(carrito))
        }
        if (typeof window !== 'undefined') {
            localStorage.setItem('carritoMedida', JSON.stringify(carritoMedida))
        }
    }, [])

    return (
        <div className="flex flex-col gap-10 justify-center items-center py-20 px-10">
            <img src={LogoEversafe} alt="Logo Eversafe" />
            <img src={IconFin} alt="Icono compra exitosa" width={150} height={50} />
            <h2 className="text-3xl lg:text-4xl text-eGray font-MontserratBold">¡Muchas gracias!</h2>
            <p className="text-eGray font-MontserratSemiBold text-center">Tu compra se ha realizado con éxito. Se ha enviado un correo electrónico con toda la información de tu orden.</p>
            <Link className="bg-eYellow rounded-md py-3 px-6" to="/">Ir al inicio</Link>
        </div>
    )
}

export default CompraFinalizada
