# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

### [0.4.11](https://github.com/themesberg/flowbite-react/compare/v0.4.10...v0.4.11) (2023-07-10)


### Features

* **dropdown.tsx:** Dropdown Accessibility ([#840](https://github.com/themesberg/flowbite-react/issues/840)) ([65b13e7](https://github.com/themesberg/flowbite-react/commit/65b13e7dd5def51076348bd9e06b6505419167cd)), closes [#648](https://github.com/themesberg/flowbite-react/issues/648) [#793](https://github.com/themesberg/flowbite-react/issues/793)


### Bug Fixes

* **dropdown:** fix build ([2c0f9e5](https://github.com/themesberg/flowbite-react/commit/2c0f9e55b2210a4b4b28237fa25193580521e7f9))
* **modal:** backdrop height ([#839](https://github.com/themesberg/flowbite-react/issues/839)) ([e6e1b83](https://github.com/themesberg/flowbite-react/commit/e6e1b834ccd87b32f685c8e1c4f268f75274e1a7))

### [0.4.10](https://github.com/themesberg/flowbite-react/compare/v0.4.9...v0.4.10) (2023-07-03)


### Features

* **button.tsx:** Added as prop to button component ([#826](https://github.com/themesberg/flowbite-react/issues/826)) ([6384882](https://github.com/themesberg/flowbite-react/commit/6384882b754465aac2829dc9e634b0c30efce621)), closes [#655](https://github.com/themesberg/flowbite-react/issues/655)
* **carousel:** adds onSlideChange property ([#833](https://github.com/themesberg/flowbite-react/issues/833)) ([c80fb37](https://github.com/themesberg/flowbite-react/commit/c80fb37ca59d1a7ceff3fef978bea934baf43c46))
* **components/darkthemetoggle:** supports custom icons ([1d615c0](https://github.com/themesberg/flowbite-react/commit/1d615c0bfbef4fdc48d9f19c18c069a15c74e228))
* **components/sidebar:** theme access to list item element ([d7262ba](https://github.com/themesberg/flowbite-react/commit/d7262bab7c97c6e215431ff7d6ca6711e23570de))
* **dropdown:** adding custom trigger ([#834](https://github.com/themesberg/flowbite-react/issues/834)) ([70c7aec](https://github.com/themesberg/flowbite-react/commit/70c7aec813f208c179a74b6b49343faf18369964)), closes [#624](https://github.com/themesberg/flowbite-react/issues/624)


### Bug Fixes

* **button.tsx:** Disable Button hover state when button is disabled ([#830](https://github.com/themesberg/flowbite-react/issues/830)) ([2b45084](https://github.com/themesberg/flowbite-react/commit/2b45084a82851d7e96e21cf75a2c8a1d1fa94e10)), closes [#827](https://github.com/themesberg/flowbite-react/issues/827)
* **components/navbar:** fix theme interface ([bc280fc](https://github.com/themesberg/flowbite-react/commit/bc280fc4fc380ec61aa67b57090a1d8bed43a488))
* **textinput.tsx:** TextInput padding when having right/left icons ([#832](https://github.com/themesberg/flowbite-react/issues/832)) ([d616e66](https://github.com/themesberg/flowbite-react/commit/d616e66e894bd80d5c95965047ea5c67ba45df91)), closes [#828](https://github.com/themesberg/flowbite-react/issues/828)

### [0.4.9](https://github.com/themesberg/flowbite-react/compare/v0.4.7...v0.4.9) (2023-06-22)


### Features

* replace `classnames` by `tailwind-merge` ([#816](https://github.com/themesberg/flowbite-react/issues/816)) ([7461173](https://github.com/themesberg/flowbite-react/commit/7461173ddb2afae9f66b9a4475b4333adef1e163))


### Bug Fixes

* **paginationbutton.tsx:** button now has type button ([#811](https://github.com/themesberg/flowbite-react/issues/811)) ([470c359](https://github.com/themesberg/flowbite-react/commit/470c3594c26706fff17a4e9932850e51d6e3e4a5)), closes [#809](https://github.com/themesberg/flowbite-react/issues/809)
* **src/components/navbar:** change default `<Navbar.Toggle/>` icon ([#819](https://github.com/themesberg/flowbite-react/issues/819)) ([6bc0de9](https://github.com/themesberg/flowbite-react/commit/6bc0de946c093863eab6386c26efc38779cb48fe)), closes [#818](https://github.com/themesberg/flowbite-react/issues/818) [/stackoverflow.com/questions/72146352/vitest-defineconfig-test-does-not-exist-in-type-userconfigexport/73106019#73106019](https://github.com/themesberg//stackoverflow.com/questions/72146352/vitest-defineconfig-test-does-not-exist-in-type-userconfigexport/73106019/issues/73106019)

### [0.4.8](https://github.com/themesberg/flowbite-react/compare/v0.4.7...v0.4.8) (2023-06-22)


### Features

* replace `classnames` by `tailwind-merge` ([#816](https://github.com/themesberg/flowbite-react/issues/816)) ([7461173](https://github.com/themesberg/flowbite-react/commit/7461173ddb2afae9f66b9a4475b4333adef1e163))


### Bug Fixes

* **paginationbutton.tsx:** button now has type button ([#811](https://github.com/themesberg/flowbite-react/issues/811)) ([470c359](https://github.com/themesberg/flowbite-react/commit/470c3594c26706fff17a4e9932850e51d6e3e4a5)), closes [#809](https://github.com/themesberg/flowbite-react/issues/809)

### [0.4.7](https://github.com/themesberg/flowbite-react/compare/v0.4.4...v0.4.7) (2023-06-01)


### Features

* **pagination.tsx:** next and previous buttons should disable when on 1 and last page respectively ([#731](https://github.com/themesberg/flowbite-react/issues/731)) ([8e8531b](https://github.com/themesberg/flowbite-react/commit/8e8531b2a1dfefcf7c9871dfa8fd441337baae6e)), closes [#726](https://github.com/themesberg/flowbite-react/issues/726) [#726](https://github.com/themesberg/flowbite-react/issues/726)


### Bug Fixes

* **button.tsx:** make prop theme work ([#746](https://github.com/themesberg/flowbite-react/issues/746)) ([1b07a76](https://github.com/themesberg/flowbite-react/commit/1b07a760e5b1394c036ae212403f49d2a631d4fb))
* **component:** fix Label component disabled property not applying theme styles ([#763](https://github.com/themesberg/flowbite-react/issues/763)) ([8d6d79e](https://github.com/themesberg/flowbite-react/commit/8d6d79ef92ff4b3482151c5428ea3b4aa0b7e637)), closes [#762](https://github.com/themesberg/flowbite-react/issues/762)
* **dropdown:** add type button in dropdown ([#757](https://github.com/themesberg/flowbite-react/issues/757)) ([974c126](https://github.com/themesberg/flowbite-react/commit/974c126e7e72833e2fde1bb9a631e4fcea6aa7af)), closes [#756](https://github.com/themesberg/flowbite-react/issues/756)
* **dropdown:** fix dropdown menu items container width ([#714](https://github.com/themesberg/flowbite-react/issues/714)) ([d13c77c](https://github.com/themesberg/flowbite-react/commit/d13c77c68960ed97828b5f9592fdb6d870a8a74d)), closes [#575](https://github.com/themesberg/flowbite-react/issues/575) [#575](https://github.com/themesberg/flowbite-react/issues/575) [#575](https://github.com/themesberg/flowbite-react/issues/575) [#575](https://github.com/themesberg/flowbite-react/issues/575) [#575](https://github.com/themesberg/flowbite-react/issues/575)
* making ToggleSwitch color prop as keyof FlowbiteColors ([#741](https://github.com/themesberg/flowbite-react/issues/741)) ([e3e2112](https://github.com/themesberg/flowbite-react/commit/e3e21126a4e38576c347f2815fb4ee51f1b1266b))
* **modal:** fixed a bug that disallowed users to set the position of a modal ([#766](https://github.com/themesberg/flowbite-react/issues/766)) ([5200ecd](https://github.com/themesberg/flowbite-react/commit/5200ecd9df760012eedb05cbe51359db2c60c8d1)), closes [#760](https://github.com/themesberg/flowbite-react/issues/760)
* **Modal:** modal scrollbar overflow style issue fixed ([#769](https://github.com/themesberg/flowbite-react/issues/769)) ([746098d](https://github.com/themesberg/flowbite-react/commit/746098d26dd3da47982e43e7e6d27044dde4a05a))
* **modal:** overflow bug fix ([#718](https://github.com/themesberg/flowbite-react/issues/718)) ([9e4e43a](https://github.com/themesberg/flowbite-react/commit/9e4e43abe17c7ea0d24b891003f41d11241f546f)), closes [#537](https://github.com/themesberg/flowbite-react/issues/537)
* pagination button not being highlighted correctly ([#725](https://github.com/themesberg/flowbite-react/issues/725)) ([53c1280](https://github.com/themesberg/flowbite-react/commit/53c1280f7b93c91413f0fb9fc2992e184591c6b3))
* **src/components/*:** replace `tsconfig.json` `paths` by relative paths ([6efd448](https://github.com/themesberg/flowbite-react/commit/6efd448ddfa647e52c3bb0927285006ba06cffc8)), closes [#772](https://github.com/themesberg/flowbite-react/issues/772)
* **theme:** typo in bottom-center ([#717](https://github.com/themesberg/flowbite-react/issues/717)) ([89d58dc](https://github.com/themesberg/flowbite-react/commit/89d58dc03727d150e73ec753748eb98640bc84a3))
* **tsconfig.lib:** compile to react-jsx for npm ([389dd1d](https://github.com/themesberg/flowbite-react/commit/389dd1d414feb7f96c28cfd8fb6b00efc55355a9))

### [0.4.6](https://github.com/themesberg/flowbite-react/compare/v0.4.6-beta.1...v0.4.6) (2023-05-26)

### [0.4.5](https://github.com/themesberg/flowbite-react/compare/v0.4.4...v0.4.5) (2023-05-26)

### Features

- **pagination.tsx:** next and previous buttons should disable when on 1 and last page respectively ([#731](https://github.com/themesberg/flowbite-react/issues/731)) ([8e8531b](https://github.com/themesberg/flowbite-react/commit/8e8531b2a1dfefcf7c9871dfa8fd441337baae6e)), closes [#726](https://github.com/themesberg/flowbite-react/issues/726) [#726](https://github.com/themesberg/flowbite-react/issues/726)

### Bug Fixes

- **button.tsx:** make prop theme work ([#746](https://github.com/themesberg/flowbite-react/issues/746)) ([1b07a76](https://github.com/themesberg/flowbite-react/commit/1b07a760e5b1394c036ae212403f49d2a631d4fb))
- **component:** fix Label component disabled property not applying theme styles ([#763](https://github.com/themesberg/flowbite-react/issues/763)) ([8d6d79e](https://github.com/themesberg/flowbite-react/commit/8d6d79ef92ff4b3482151c5428ea3b4aa0b7e637)), closes [#762](https://github.com/themesberg/flowbite-react/issues/762)
- **dropdown:** add type button in dropdown ([#757](https://github.com/themesberg/flowbite-react/issues/757)) ([974c126](https://github.com/themesberg/flowbite-react/commit/974c126e7e72833e2fde1bb9a631e4fcea6aa7af)), closes [#756](https://github.com/themesberg/flowbite-react/issues/756)
- **dropdown:** fix dropdown menu items container width ([#714](https://github.com/themesberg/flowbite-react/issues/714)) ([d13c77c](https://github.com/themesberg/flowbite-react/commit/d13c77c68960ed97828b5f9592fdb6d870a8a74d)), closes [#575](https://github.com/themesberg/flowbite-react/issues/575) [#575](https://github.com/themesberg/flowbite-react/issues/575) [#575](https://github.com/themesberg/flowbite-react/issues/575) [#575](https://github.com/themesberg/flowbite-react/issues/575) [#575](https://github.com/themesberg/flowbite-react/issues/575)
- making ToggleSwitch color prop as keyof FlowbiteColors ([#741](https://github.com/themesberg/flowbite-react/issues/741)) ([e3e2112](https://github.com/themesberg/flowbite-react/commit/e3e21126a4e38576c347f2815fb4ee51f1b1266b))
- **Modal:** modal scrollbar overflow style issue fixed ([#769](https://github.com/themesberg/flowbite-react/issues/769)) ([746098d](https://github.com/themesberg/flowbite-react/commit/746098d26dd3da47982e43e7e6d27044dde4a05a))
- **modal:** overflow bug fix ([#718](https://github.com/themesberg/flowbite-react/issues/718)) ([9e4e43a](https://github.com/themesberg/flowbite-react/commit/9e4e43abe17c7ea0d24b891003f41d11241f546f)), closes [#537](https://github.com/themesberg/flowbite-react/issues/537)
- pagination button not being highlighted correctly ([#725](https://github.com/themesberg/flowbite-react/issues/725)) ([53c1280](https://github.com/themesberg/flowbite-react/commit/53c1280f7b93c91413f0fb9fc2992e184591c6b3))
- **theme:** typo in bottom-center ([#717](https://github.com/themesberg/flowbite-react/issues/717)) ([89d58dc](https://github.com/themesberg/flowbite-react/commit/89d58dc03727d150e73ec753748eb98640bc84a3))

### [0.4.4](https://github.com/themesberg/flowbite-react/compare/v0.4.1...v0.4.4) (2023-04-24)

### Features

- **/src/components/avatar:** allow custom sizes for `placeholderInitials` ([#659](https://github.com/themesberg/flowbite-react/issues/659)) ([#660](https://github.com/themesberg/flowbite-react/issues/660)) ([525b90d](https://github.com/themesberg/flowbite-react/commit/525b90dfd374f38e1c0a8527fcb92eabc849c186))
- **/src/components/progress:** fix unclear label usage ([#468](https://github.com/themesberg/flowbite-react/issues/468)) ([#547](https://github.com/themesberg/flowbite-react/issues/547)) ([f9cad02](https://github.com/themesberg/flowbite-react/commit/f9cad02d6d9b0f699c420167ccb0e373913ef1ce))
- **sidebar:** Allow to customize the Sidebar component with 'as' ([#703](https://github.com/themesberg/flowbite-react/issues/703)) ([54fc3c2](https://github.com/themesberg/flowbite-react/commit/54fc3c2046f45698542bb14fb95af467eafffa99))
- **Toast:** add onClick prop to Toast.Toggle ([#607](https://github.com/themesberg/flowbite-react/issues/607)) ([#666](https://github.com/themesberg/flowbite-react/issues/666)) ([9be39d0](https://github.com/themesberg/flowbite-react/commit/9be39d0f4c2f8da9bdd54003d9a6f2d983d16345))

### Bug Fixes

- **/lib/components/table:** prevent scrollbars around `<Table>`s ([#608](https://github.com/themesberg/flowbite-react/issues/608)) ([6f1869b](https://github.com/themesberg/flowbite-react/commit/6f1869bac86c1dcbda622413a197f67536803f53))
- **/src/lib/components/\*:** add `displayName` to Forms components ([#656](https://github.com/themesberg/flowbite-react/issues/656)) ([329cb5a](https://github.com/themesberg/flowbite-react/commit/329cb5ad6383244f38e11cac57050dc684d6c3c5)), closes [#641](https://github.com/themesberg/flowbite-react/issues/641)
- **/src/lib/components/\*:** allow `theme={}` to contain partials ([#649](https://github.com/themesberg/flowbite-react/issues/649)) ([863a789](https://github.com/themesberg/flowbite-react/commit/863a789ed169cbfcbe05d5de7e9021a074872063)), closes [#646](https://github.com/themesberg/flowbite-react/issues/646)
- **/src/lib/components/Flowbite:** fix `window is not defined` in `next.js` ([#652](https://github.com/themesberg/flowbite-react/issues/652)) ([8fd9ddc](https://github.com/themesberg/flowbite-react/commit/8fd9ddcc5fcd8d5926c0e871dd25493d5d2c255f))
- **/src/theme:** fix `<Modal>` vertical positioning ([#658](https://github.com/themesberg/flowbite-react/issues/658)) ([5fec3ca](https://github.com/themesberg/flowbite-react/commit/5fec3ca0710b1883a4de622453c896346c8ab8c0)), closes [#601](https://github.com/themesberg/flowbite-react/issues/601)
- added aria-label to solve Buttons do not have an accessible name… ([#711](https://github.com/themesberg/flowbite-react/issues/711)) ([65b0aef](https://github.com/themesberg/flowbite-react/commit/65b0aef13143d5efc0bb00bd2ab221573ec4c2ef))
- **button:** fixes outline button ([#654](https://github.com/themesberg/flowbite-react/issues/654)) ([eab6bbb](https://github.com/themesberg/flowbite-react/commit/eab6bbb6f78b46fb298e75344442b75f028d5cff))
- **component/models:** prevent scrolling of body when modal is shown ([#700](https://github.com/themesberg/flowbite-react/issues/700)) ([ab6e96a](https://github.com/themesberg/flowbite-react/commit/ab6e96a58bc5b39b0b80cdc898c634f9fbab7462)), closes [#604](https://github.com/themesberg/flowbite-react/issues/604)
- **component/progressbar:** fix progressbar showing label when progress == 0 ([#698](https://github.com/themesberg/flowbite-react/issues/698)) ([1fa7542](https://github.com/themesberg/flowbite-react/commit/1fa7542c687fc164f1cdbd6362fd35ac978942f1)), closes [#668](https://github.com/themesberg/flowbite-react/issues/668)
- **components/accordion:** allow opened panel to be closed [#684](https://github.com/themesberg/flowbite-react/issues/684) - add accordion tests ([#705](https://github.com/themesberg/flowbite-react/issues/705)) ([7de751e](https://github.com/themesberg/flowbite-react/commit/7de751e4a80b144edd7f3fdc7eaa4ca2ea655dad)), closes [#618](https://github.com/themesberg/flowbite-react/issues/618)
- group list styling ([#668](https://github.com/themesberg/flowbite-react/issues/668)) ([a4f39f5](https://github.com/themesberg/flowbite-react/commit/a4f39f5608a46f6c0d4661fa383e70583ab7d592))
- **lib/components/buttons:** Add `target` to `Button` props to open a link in new tab ([#631](https://github.com/themesberg/flowbite-react/issues/631)) ([ed74d13](https://github.com/themesberg/flowbite-react/commit/ed74d1361d03fd01f5eac2b3ca8faa382718afba))
- **sidebar:** adds missing className ([#657](https://github.com/themesberg/flowbite-react/issues/657)) ([12fce11](https://github.com/themesberg/flowbite-react/commit/12fce11aad6bb0d2ca5058ce9fffee629038e542))
- **tabs:** remove tab auto focus ([#712](https://github.com/themesberg/flowbite-react/issues/712)) ([6942943](https://github.com/themesberg/flowbite-react/commit/6942943639025a7310606af7fa6c2ffa68755d84)), closes [#612](https://github.com/themesberg/flowbite-react/issues/612) [#612](https://github.com/themesberg/flowbite-react/issues/612)

### [0.4.3](https://github.com/themesberg/flowbite-react/compare/v0.4.2...v0.4.3) (2023-04-05)

### Features

- **Toast:** add onClick prop to Toast.Toggle ([#607](https://github.com/themesberg/flowbite-react/issues/607)) ([#666](https://github.com/themesberg/flowbite-react/issues/666)) ([9be39d0](https://github.com/themesberg/flowbite-react/commit/9be39d0f4c2f8da9bdd54003d9a6f2d983d16345))

### [0.4.2](https://github.com/themesberg/flowbite-react/compare/v0.4.1...v0.4.2) (2023-03-08)

### Features

- **/src/components/avatar:** allow custom sizes for `placeholderInitials` ([#659](https://github.com/themesberg/flowbite-react/issues/659)) ([#660](https://github.com/themesberg/flowbite-react/issues/660)) ([525b90d](https://github.com/themesberg/flowbite-react/commit/525b90dfd374f38e1c0a8527fcb92eabc849c186))
- **/src/components/progress:** fix unclear label usage ([#468](https://github.com/themesberg/flowbite-react/issues/468)) ([#547](https://github.com/themesberg/flowbite-react/issues/547)) ([f9cad02](https://github.com/themesberg/flowbite-react/commit/f9cad02d6d9b0f699c420167ccb0e373913ef1ce))

### Bug Fixes

- **/src/lib/components/\*:** add `displayName` to Forms components ([#656](https://github.com/themesberg/flowbite-react/issues/656)) ([329cb5a](https://github.com/themesberg/flowbite-react/commit/329cb5ad6383244f38e11cac57050dc684d6c3c5)), closes [#641](https://github.com/themesberg/flowbite-react/issues/641)
- **/src/lib/components/\*:** allow `theme={}` to contain partials ([#649](https://github.com/themesberg/flowbite-react/issues/649)) ([863a789](https://github.com/themesberg/flowbite-react/commit/863a789ed169cbfcbe05d5de7e9021a074872063)), closes [#646](https://github.com/themesberg/flowbite-react/issues/646)
- **/src/lib/components/Flowbite:** fix `window is not defined` in `next.js` ([#652](https://github.com/themesberg/flowbite-react/issues/652)) ([8fd9ddc](https://github.com/themesberg/flowbite-react/commit/8fd9ddcc5fcd8d5926c0e871dd25493d5d2c255f))
- **/src/theme:** fix `<Modal>` vertical positioning ([#658](https://github.com/themesberg/flowbite-react/issues/658)) ([5fec3ca](https://github.com/themesberg/flowbite-react/commit/5fec3ca0710b1883a4de622453c896346c8ab8c0)), closes [#601](https://github.com/themesberg/flowbite-react/issues/601)
- **button:** fixes outline button ([#654](https://github.com/themesberg/flowbite-react/issues/654)) ([eab6bbb](https://github.com/themesberg/flowbite-react/commit/eab6bbb6f78b46fb298e75344442b75f028d5cff))
- **lib/components/buttons:** Add `target` to `Button` props to open a link in new tab ([#631](https://github.com/themesberg/flowbite-react/issues/631)) ([ed74d13](https://github.com/themesberg/flowbite-react/commit/ed74d1361d03fd01f5eac2b3ca8faa382718afba))
- **sidebar:** adds missing className ([#657](https://github.com/themesberg/flowbite-react/issues/657)) ([12fce11](https://github.com/themesberg/flowbite-react/commit/12fce11aad6bb0d2ca5058ce9fffee629038e542))

### [0.4.1](https://github.com/themesberg/flowbite-react/compare/v0.3.8...v0.4.1) (2023-03-03)

### ⚠ BREAKING CHANGES

- **/lib/components/flowbite:** ThemeProps no longer includes usePreferences
- **theme:** Like in #500, this version permanently changes the `FlowbiteTheme` for numerous
  components.

The philosophy is that themes will more clearly reflect the component's structure.

For example, an `<Accordion>` can contain any number of `<Accordion.Title>` or `<Accordion.Content>`
sections. The theme used to look like:

```js
accordion: {
  base: "..",
  content: "..",
  flush: "..",
  title: "..",
}
```

And now, the theme for an `<Accordion>` looks like:

```
js
accordion: {
  root: {
    base: "..",
    flush: "..",
  },
  content: "..",
  title: "..",
}
```

So now the options in the theme which apply to the `<Accordion>` itself will always be found under
`root`. Likewise, `<Accordion.Content>` can be themed via the `content` subsection.

This ultimately will apply to all components.

- ci(eslint): remove `prettier` plugins for `eslint`

Instead, use `prettier-plugin-tailwindcss`, which is sufficient.

- refactor(/lib/\*): use `yarn prettier` with `prettier-plugin-tailwindcss`

- fix(/lib/components/\*.spec): resolve test errors caused by migrating theme

- feat(/lib/components/\*): add `theme={}` attribute to components that need it

### Features

- **/lib/components/flowbite:** remove `usePreferences` ([#582](https://github.com/themesberg/flowbite-react/issues/582)) ([77cbc27](https://github.com/themesberg/flowbite-react/commit/77cbc27aa5d42bcff1bdd54c3b5c35e37ff039a0)), closes [#581](https://github.com/themesberg/flowbite-react/issues/581) [#565](https://github.com/themesberg/flowbite-react/issues/565) [#581](https://github.com/themesberg/flowbite-react/issues/581) [#565](https://github.com/themesberg/flowbite-react/issues/565)
- **/lib/components/timeline:** change `<Timeline.Body>` to a `<div>` ([#603](https://github.com/themesberg/flowbite-react/issues/603)) ([720c8ef](https://github.com/themesberg/flowbite-react/commit/720c8ef6c707837372dddf33e9e4a73d42caea1e)), closes [#602](https://github.com/themesberg/flowbite-react/issues/602)
- **/lib/theme:** add Tailwind CSS colors to `<Alert>`s ([#586](https://github.com/themesberg/flowbite-react/issues/586)) ([05bde49](https://github.com/themesberg/flowbite-react/commit/05bde49a7fe27e456b7e3da631424705beeaabb8)), closes [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473)
- **/lib/theme:** add Tailwind CSS colors to `<Badge>`s ([#617](https://github.com/themesberg/flowbite-react/issues/617)) ([f00628f](https://github.com/themesberg/flowbite-react/commit/f00628f95059f7e4e18bbe069ceb5573471dc36d))
- **/lib/theme:** add Tailwind CSS colors to `<Button>`s ([#598](https://github.com/themesberg/flowbite-react/issues/598)) ([e88cdab](https://github.com/themesberg/flowbite-react/commit/e88cdab07f481e6a8ca8a4d4bdd2b723ec3516f4)), closes [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473)
- **theme:** add `theme={}` attribute to components that need it ([#611](https://github.com/themesberg/flowbite-react/issues/611)) ([005d78a](https://github.com/themesberg/flowbite-react/commit/005d78ac281ab14876b3b528cf3f51976d4fa349)), closes [#500](https://github.com/themesberg/flowbite-react/issues/500) [#566](https://github.com/themesberg/flowbite-react/issues/566) [#594](https://github.com/themesberg/flowbite-react/issues/594) [#124](https://github.com/themesberg/flowbite-react/issues/124) [#609](https://github.com/themesberg/flowbite-react/issues/609)

### Bug Fixes

- **/components/modal:** Prevent `<Modal.Content>` from being truncated ([#601](https://github.com/themesberg/flowbite-react/issues/601)) ([dd19f33](https://github.com/themesberg/flowbite-react/commit/dd19f330831bf83ace4a353cfda09d4f21979703)), closes [#600](https://github.com/themesberg/flowbite-react/issues/600)
- **/docs:** remove `{' '}` literals from code examples ([#614](https://github.com/themesberg/flowbite-react/issues/614)) ([2f46d90](https://github.com/themesberg/flowbite-react/commit/2f46d90473470bd4b2fa7233fc2b6e87f8055fd6))
- **tsconfig:** noEmit is false ([44f4cd7](https://github.com/themesberg/flowbite-react/commit/44f4cd73dbddcc9812ca17993d1e0ec33cb3a65e))

## [0.4.0](https://github.com/themesberg/flowbite-react/compare/v0.1.0...v0.4.0) (2023-03-03)

### ⚠ BREAKING CHANGES

- **/lib/components/flowbite:** ThemeProps no longer includes usePreferences
- **theme:** Like in #500, this version permanently changes the `FlowbiteTheme` for numerous
  components.

The philosophy is that themes will more clearly reflect the component's structure.

For example, an `<Accordion>` can contain any number of `<Accordion.Title>` or `<Accordion.Content>`
sections. The theme used to look like:

```js
accordion: {
  base: "..",
  content: "..",
  flush: "..",
  title: "..",
}
```

And now, the theme for an `<Accordion>` looks like:

```
js
accordion: {
  root: {
    base: "..",
    flush: "..",
  },
  content: "..",
  title: "..",
}
```

So now the options in the theme which apply to the `<Accordion>` itself will always be found under
`root`. Likewise, `<Accordion.Content>` can be themed via the `content` subsection.

This ultimately will apply to all components.

- ci(eslint): remove `prettier` plugins for `eslint`

Instead, use `prettier-plugin-tailwindcss`, which is sufficient.

- refactor(/lib/\*): use `yarn prettier` with `prettier-plugin-tailwindcss`

- fix(/lib/components/\*.spec): resolve test errors caused by migrating theme

- feat(/lib/components/\*): add `theme={}` attribute to components that need it

### Features

- **/lib/components/flowbite:** remove `usePreferences` ([#582](https://github.com/themesberg/flowbite-react/issues/582)) ([77cbc27](https://github.com/themesberg/flowbite-react/commit/77cbc27aa5d42bcff1bdd54c3b5c35e37ff039a0)), closes [#581](https://github.com/themesberg/flowbite-react/issues/581) [#565](https://github.com/themesberg/flowbite-react/issues/565) [#581](https://github.com/themesberg/flowbite-react/issues/581) [#565](https://github.com/themesberg/flowbite-react/issues/565)
- **/lib/components/timeline:** change `<Timeline.Body>` to a `<div>` ([#603](https://github.com/themesberg/flowbite-react/issues/603)) ([720c8ef](https://github.com/themesberg/flowbite-react/commit/720c8ef6c707837372dddf33e9e4a73d42caea1e)), closes [#602](https://github.com/themesberg/flowbite-react/issues/602)
- **/lib/theme:** add Tailwind CSS colors to `<Alert>`s ([#586](https://github.com/themesberg/flowbite-react/issues/586)) ([05bde49](https://github.com/themesberg/flowbite-react/commit/05bde49a7fe27e456b7e3da631424705beeaabb8)), closes [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473)
- **/lib/theme:** add Tailwind CSS colors to `<Badge>`s ([#617](https://github.com/themesberg/flowbite-react/issues/617)) ([f00628f](https://github.com/themesberg/flowbite-react/commit/f00628f95059f7e4e18bbe069ceb5573471dc36d))
- **/lib/theme:** add Tailwind CSS colors to `<Button>`s ([#598](https://github.com/themesberg/flowbite-react/issues/598)) ([e88cdab](https://github.com/themesberg/flowbite-react/commit/e88cdab07f481e6a8ca8a4d4bdd2b723ec3516f4)), closes [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473) [#473](https://github.com/themesberg/flowbite-react/issues/473)
- **accordion:** add collapseAll prop ([#515](https://github.com/themesberg/flowbite-react/issues/515)) ([#524](https://github.com/themesberg/flowbite-react/issues/524)) ([d2206b5](https://github.com/themesberg/flowbite-react/commit/d2206b558f7d3a096f17226361d1c8b0aa52ce52))
- add theme prop ([#488](https://github.com/themesberg/flowbite-react/issues/488)) ([fb34230](https://github.com/themesberg/flowbite-react/commit/fb34230be5093d2dd5700b7253c08f3ab622f667))
- allow using initials as `Avatar` placeholder ([#375](https://github.com/themesberg/flowbite-react/issues/375)) ([e349d82](https://github.com/themesberg/flowbite-react/commit/e349d82ca1d0933ea037655022b38aa1b9836a33)), closes [#357](https://github.com/themesberg/flowbite-react/issues/357) [#357](https://github.com/themesberg/flowbite-react/issues/357) [#357](https://github.com/themesberg/flowbite-react/issues/357) [#357](https://github.com/themesberg/flowbite-react/issues/357)
- **avatar:** adds color prop and test case for it ([#439](https://github.com/themesberg/flowbite-react/issues/439)) ([104d6fb](https://github.com/themesberg/flowbite-react/commit/104d6fb83bd48de696c2b79138640e747e5b020f)), closes [#409](https://github.com/themesberg/flowbite-react/issues/409) [#409](https://github.com/themesberg/flowbite-react/issues/409)
- **Avatar:** Support overriding the Avatar img element. Fixes [#482](https://github.com/themesberg/flowbite-react/issues/482) ([#483](https://github.com/themesberg/flowbite-react/issues/483)) ([8f87019](https://github.com/themesberg/flowbite-react/commit/8f87019e58a320bc78c07b6a04fd6a99d6376d39))
- **breadcrumbitem:** add forwardRef to breadcrumb item ([#421](https://github.com/themesberg/flowbite-react/issues/421)) ([0e4ae62](https://github.com/themesberg/flowbite-react/commit/0e4ae62b2b93561c4857bea63df45fe9170f546e))
- **button:** added forwardRef to button component ([#391](https://github.com/themesberg/flowbite-react/issues/391)) ([3278c84](https://github.com/themesberg/flowbite-react/commit/3278c84ba15bc754032c4e248eb31e64d8bb53ff)), closes [#341](https://github.com/themesberg/flowbite-react/issues/341)
- **classname:** all components with classname access ([#405](https://github.com/themesberg/flowbite-react/issues/405)) ([99b4ceb](https://github.com/themesberg/flowbite-react/commit/99b4cebf5f92e8f3eb15851dcb0b6997c8606c47))
- **classname:** more missing classnames access ([#406](https://github.com/themesberg/flowbite-react/issues/406)) ([9e40115](https://github.com/themesberg/flowbite-react/commit/9e4011554cc132fd24bff286955b5f2d6861e1f8))
- **components:** export components types ([#434](https://github.com/themesberg/flowbite-react/issues/434)) ([45ea65a](https://github.com/themesberg/flowbite-react/commit/45ea65a4e1e376b398f462d07b9a1f1ea2ca114b)), closes [#433](https://github.com/themesberg/flowbite-react/issues/433)
- **Navbar:** add as prop ([#526](https://github.com/themesberg/flowbite-react/issues/526)) ([#528](https://github.com/themesberg/flowbite-react/issues/528)) ([21dab1f](https://github.com/themesberg/flowbite-react/commit/21dab1fe576a09d33c8ecd35cd10cf93eb332e9a))
- **RangeSlider:** range slider with custom theme, storybook, unit test and docs ([#548](https://github.com/themesberg/flowbite-react/issues/548)) ([5f01946](https://github.com/themesberg/flowbite-react/commit/5f0194679a0d6e2d75f7cbe8bdd05ac34d5ad873))
- **sidebaritem:** add forwardRef to sidebar item ([#420](https://github.com/themesberg/flowbite-react/issues/420)) ([faca797](https://github.com/themesberg/flowbite-react/commit/faca797b0b8ce7a94b40a44019c7323e721af5e5)), closes [#397](https://github.com/themesberg/flowbite-react/issues/397)
- TextInput with RightIcon ([#437](https://github.com/themesberg/flowbite-react/issues/437)) ([7d72e1e](https://github.com/themesberg/flowbite-react/commit/7d72e1eef07baf870a84a3e2eca950bb1814a316)), closes [#436](https://github.com/themesberg/flowbite-react/issues/436) [#436](https://github.com/themesberg/flowbite-react/issues/436) [#436](https://github.com/themesberg/flowbite-react/issues/436) [#436](https://github.com/themesberg/flowbite-react/issues/436)
- **theme:** add `theme={}` attribute to components that need it ([#611](https://github.com/themesberg/flowbite-react/issues/611)) ([005d78a](https://github.com/themesberg/flowbite-react/commit/005d78ac281ab14876b3b528cf3f51976d4fa349)), closes [#500](https://github.com/themesberg/flowbite-react/issues/500) [#566](https://github.com/themesberg/flowbite-react/issues/566) [#594](https://github.com/themesberg/flowbite-react/issues/594) [#124](https://github.com/themesberg/flowbite-react/issues/124) [#609](https://github.com/themesberg/flowbite-react/issues/609)
- **theme:** add tests for alert component ([#549](https://github.com/themesberg/flowbite-react/issues/549)) ([a62e84f](https://github.com/themesberg/flowbite-react/commit/a62e84fed43c0ee39e7b40f4e223ebcb11edd14a))
- **theme:** add theme support for Checkbox, Radio and ToggleSwitch ([#551](https://github.com/themesberg/flowbite-react/issues/551)) ([05c934a](https://github.com/themesberg/flowbite-react/commit/05c934adb2abf6af44784069388f13af2966ba38))
- **theme:** adding theme support per component ([#500](https://github.com/themesberg/flowbite-react/issues/500)) ([2f58ae2](https://github.com/themesberg/flowbite-react/commit/2f58ae2139359ef1acf7a417a1ffa337570ce221)), closes [#467](https://github.com/themesberg/flowbite-react/issues/467)
- **themecontext:** exported theme hooks and updated docs ([#390](https://github.com/themesberg/flowbite-react/issues/390)) ([37644b7](https://github.com/themesberg/flowbite-react/commit/37644b7247a35ce15df0379425139585bc8ae27f)), closes [#389](https://github.com/themesberg/flowbite-react/issues/389)

### Bug Fixes

- **/components/modal:** Prevent `<Modal.Content>` from being truncated ([#601](https://github.com/themesberg/flowbite-react/issues/601)) ([dd19f33](https://github.com/themesberg/flowbite-react/commit/dd19f330831bf83ace4a353cfda09d4f21979703)), closes [#600](https://github.com/themesberg/flowbite-react/issues/600)
- **/docs:** remove `{' '}` literals from code examples ([#614](https://github.com/themesberg/flowbite-react/issues/614)) ([2f46d90](https://github.com/themesberg/flowbite-react/commit/2f46d90473470bd4b2fa7233fc2b6e87f8055fd6))
- **avatar:** center avatar correctly ([#404](https://github.com/themesberg/flowbite-react/issues/404)) ([1027212](https://github.com/themesberg/flowbite-react/commit/1027212dc5e3d030c65b418c3710d07d577e4016))
- Button doesn't fit to its parent width ([#370](https://github.com/themesberg/flowbite-react/issues/370)) ([15571aa](https://github.com/themesberg/flowbite-react/commit/15571aa27e7fe96b8aae6e6eaec22e03cab17814))
- **button:** reduce the thickness of button outline ([#376](https://github.com/themesberg/flowbite-react/issues/376)) ([5ef0aef](https://github.com/themesberg/flowbite-react/commit/5ef0aeff0e90d4de47d1d1e9a954a792a473860d))
- **component:** add missing display name for checkbox, radio and select ([#328](https://github.com/themesberg/flowbite-react/issues/328)) ([8c307aa](https://github.com/themesberg/flowbite-react/commit/8c307aa1b072d82c2779d5de2dabb5609759689e))
- **component:** display text only on Sidebar.Item tooltip ([#315](https://github.com/themesberg/flowbite-react/issues/315)) ([9af5d13](https://github.com/themesberg/flowbite-react/commit/9af5d136a95cadd91c3212080bb060091ce3453d)), closes [#258](https://github.com/themesberg/flowbite-react/issues/258)
- **component:** remove "All Rights Reserved" from `<Footer.Copyright>` ([#317](https://github.com/themesberg/flowbite-react/issues/317)) ([c6524ee](https://github.com/themesberg/flowbite-react/commit/c6524eea31491480fe85870f22829a96c819c414))
- **component:** Remove `type="button"` when not a `<button>` ([#217](https://github.com/themesberg/flowbite-react/issues/217)) ([8c7012e](https://github.com/themesberg/flowbite-react/commit/8c7012e77b5ca2abde0b8d30ca1ad38cf70cbdd0))
- **component:** use 1st letter of text in collapsed Sidebar.Item with no icon ([#338](https://github.com/themesberg/flowbite-react/issues/338)) ([103d173](https://github.com/themesberg/flowbite-react/commit/103d17324d388fe60898697ed42811428af169bb)), closes [#81](https://github.com/themesberg/flowbite-react/issues/81)
- **DarkThemeToggle:** should toggle the theme with `usePreferences` is false ([#417](https://github.com/themesberg/flowbite-react/issues/417)) ([#424](https://github.com/themesberg/flowbite-react/issues/424)) ([37244ff](https://github.com/themesberg/flowbite-react/commit/37244ff2bbdaecbea8a0bcce0243c8d6f2ee9151))
- **dropdown:** close dropdown when item is selected ([#392](https://github.com/themesberg/flowbite-react/issues/392)) ([05f5534](https://github.com/themesberg/flowbite-react/commit/05f5534e972c750b979f6eaa225a5f0f98738ffb)), closes [#349](https://github.com/themesberg/flowbite-react/issues/349) [#349](https://github.com/themesberg/flowbite-react/issues/349) [#349](https://github.com/themesberg/flowbite-react/issues/349)
- **helpers/mergedeep:** fix potential cases when source or target obects can be mutated ([#476](https://github.com/themesberg/flowbite-react/issues/476)) ([765fedb](https://github.com/themesberg/flowbite-react/commit/765fedb3c966ea93e384339f6e121beda320c22f))
- **modal:** clear modal container ref on unmount ([#514](https://github.com/themesberg/flowbite-react/issues/514)) ([3387128](https://github.com/themesberg/flowbite-react/commit/338712844bf5d4831004ca3c0660a4180f14202b))
- **modal:** fix initial focus inside a modal ([#495](https://github.com/themesberg/flowbite-react/issues/495)) ([6965074](https://github.com/themesberg/flowbite-react/commit/69650741dcd0bdde710e6e2a6f3687431e44deaf))
- **package:** minimal react version is 18 ([#344](https://github.com/themesberg/flowbite-react/issues/344)) ([bc4fea7](https://github.com/themesberg/flowbite-react/commit/bc4fea7ecbc83dcbff61a5d01805008993a66a71))
- **pagination:** fix next button icon misalignment ([#346](https://github.com/themesberg/flowbite-react/issues/346)) ([0dd10d3](https://github.com/themesberg/flowbite-react/commit/0dd10d339a17961743c6d8a4ceb5c8e06677c0df)), closes [#330](https://github.com/themesberg/flowbite-react/issues/330)
- render border colors in Avatar with placeholder initials ([#521](https://github.com/themesberg/flowbite-react/issues/521)) ([3aa12c6](https://github.com/themesberg/flowbite-react/commit/3aa12c660a4327c043fae26966b273bbae28ba66))
- **sidebaritem:** fix sidebar item with next link ([#438](https://github.com/themesberg/flowbite-react/issues/438)) ([32f337b](https://github.com/themesberg/flowbite-react/commit/32f337bea352909b18d803cd7d39b1af46069945))
- **storybook:** fix welcome page ([#377](https://github.com/themesberg/flowbite-react/issues/377)) ([d2518ad](https://github.com/themesberg/flowbite-react/commit/d2518adf4ace2d062a2f370b18994cd44cebbb42))
- **textinput:** merge issue ([#499](https://github.com/themesberg/flowbite-react/issues/499)) ([f8eca21](https://github.com/themesberg/flowbite-react/commit/f8eca210c85adacd018e9ce9010295858b21251d))
- **theme:** add z-index to Dropdown floating component ([#314](https://github.com/themesberg/flowbite-react/issues/314)) ([77cb356](https://github.com/themesberg/flowbite-react/commit/77cb3560538751aa256b7c24e71df9fd6bec0c36)), closes [#308](https://github.com/themesberg/flowbite-react/issues/308)
- timeline-horizontal ([#510](https://github.com/themesberg/flowbite-react/issues/510)) ([89d2ff8](https://github.com/themesberg/flowbite-react/commit/89d2ff8ae64ddf334ec0d718ca9fa3ff3605be85))
- **toast:** ToastToggle must have className ([#471](https://github.com/themesberg/flowbite-react/issues/471)) ([5618b21](https://github.com/themesberg/flowbite-react/commit/5618b21626afa92fe64b99ef9b1f178724b61d4a))
- typo in navbar theme typedef ([#327](https://github.com/themesberg/flowbite-react/issues/327)) ([459a864](https://github.com/themesberg/flowbite-react/commit/459a8648f054b80fc4499ecd68689bc3d3d0c244))

### [0.3.8](https://github.com/themesberg/flowbite-react/compare/v0.3.7...v0.3.8) (2023-01-26)

### Features

- **accordion:** add collapseAll prop ([#515](https://github.com/themesberg/flowbite-react/issues/515)) ([#524](https://github.com/themesberg/flowbite-react/issues/524)) ([d2206b5](https://github.com/themesberg/flowbite-react/commit/d2206b558f7d3a096f17226361d1c8b0aa52ce52))
- add theme prop ([#488](https://github.com/themesberg/flowbite-react/issues/488)) ([fb34230](https://github.com/themesberg/flowbite-react/commit/fb34230be5093d2dd5700b7253c08f3ab622f667))
- **Avatar:** Support overriding the Avatar img element. Fixes [#482](https://github.com/themesberg/flowbite-react/issues/482) ([#483](https://github.com/themesberg/flowbite-react/issues/483)) ([8f87019](https://github.com/themesberg/flowbite-react/commit/8f87019e58a320bc78c07b6a04fd6a99d6376d39))
- **Navbar:** add as prop ([#526](https://github.com/themesberg/flowbite-react/issues/526)) ([#528](https://github.com/themesberg/flowbite-react/issues/528)) ([21dab1f](https://github.com/themesberg/flowbite-react/commit/21dab1fe576a09d33c8ecd35cd10cf93eb332e9a))
- **RangeSlider:** range slider with custom theme, storybook, unit test and docs ([#548](https://github.com/themesberg/flowbite-react/issues/548)) ([5f01946](https://github.com/themesberg/flowbite-react/commit/5f0194679a0d6e2d75f7cbe8bdd05ac34d5ad873))
- TextInput with RightIcon ([#437](https://github.com/themesberg/flowbite-react/issues/437)) ([7d72e1e](https://github.com/themesberg/flowbite-react/commit/7d72e1eef07baf870a84a3e2eca950bb1814a316)), closes [#436](https://github.com/themesberg/flowbite-react/issues/436) [#436](https://github.com/themesberg/flowbite-react/issues/436) [#436](https://github.com/themesberg/flowbite-react/issues/436) [#436](https://github.com/themesberg/flowbite-react/issues/436)
- **theme:** add tests for alert component ([#549](https://github.com/themesberg/flowbite-react/issues/549)) ([a62e84f](https://github.com/themesberg/flowbite-react/commit/a62e84fed43c0ee39e7b40f4e223ebcb11edd14a))
- **theme:** add theme support for Checkbox, Radio and ToggleSwitch ([#551](https://github.com/themesberg/flowbite-react/issues/551)) ([05c934a](https://github.com/themesberg/flowbite-react/commit/05c934adb2abf6af44784069388f13af2966ba38))
- **theme:** adding theme support per component ([#500](https://github.com/themesberg/flowbite-react/issues/500)) ([2f58ae2](https://github.com/themesberg/flowbite-react/commit/2f58ae2139359ef1acf7a417a1ffa337570ce221)), closes [#467](https://github.com/themesberg/flowbite-react/issues/467)

### Bug Fixes

- **helpers/mergedeep:** fix potential cases when source or target obects can be mutated ([#476](https://github.com/themesberg/flowbite-react/issues/476)) ([765fedb](https://github.com/themesberg/flowbite-react/commit/765fedb3c966ea93e384339f6e121beda320c22f))
- **modal:** clear modal container ref on unmount ([#514](https://github.com/themesberg/flowbite-react/issues/514)) ([3387128](https://github.com/themesberg/flowbite-react/commit/338712844bf5d4831004ca3c0660a4180f14202b))
- **modal:** fix initial focus inside a modal ([#495](https://github.com/themesberg/flowbite-react/issues/495)) ([6965074](https://github.com/themesberg/flowbite-react/commit/69650741dcd0bdde710e6e2a6f3687431e44deaf))
- render border colors in Avatar with placeholder initials ([#521](https://github.com/themesberg/flowbite-react/issues/521)) ([3aa12c6](https://github.com/themesberg/flowbite-react/commit/3aa12c660a4327c043fae26966b273bbae28ba66))
- **sidebaritem:** fix sidebar item with next link ([#438](https://github.com/themesberg/flowbite-react/issues/438)) ([32f337b](https://github.com/themesberg/flowbite-react/commit/32f337bea352909b18d803cd7d39b1af46069945))
- **textinput:** merge issue ([#499](https://github.com/themesberg/flowbite-react/issues/499)) ([f8eca21](https://github.com/themesberg/flowbite-react/commit/f8eca210c85adacd018e9ce9010295858b21251d))
- timeline-horizontal ([#510](https://github.com/themesberg/flowbite-react/issues/510)) ([89d2ff8](https://github.com/themesberg/flowbite-react/commit/89d2ff8ae64ddf334ec0d718ca9fa3ff3605be85))

### [0.3.7](https://github.com/themesberg/flowbite-react/compare/v0.3.6...v0.3.7) (2022-12-06)

### Bug Fixes

- **toast:** ToastToggle must have className ([#471](https://github.com/themesberg/flowbite-react/issues/471)) ([5618b21](https://github.com/themesberg/flowbite-react/commit/5618b21626afa92fe64b99ef9b1f178724b61d4a))

### [0.3.6](https://github.com/themesberg/flowbite-react/compare/v0.3.5...v0.3.6) (2022-12-02)

### Features

- **avatar:** adds color prop and test case for it ([#439](https://github.com/themesberg/flowbite-react/issues/439)) ([104d6fb](https://github.com/themesberg/flowbite-react/commit/104d6fb83bd48de696c2b79138640e747e5b020f)), closes [#409](https://github.com/themesberg/flowbite-react/issues/409) [#409](https://github.com/themesberg/flowbite-react/issues/409)

### [0.3.5](https://github.com/themesberg/flowbite-react/compare/v0.3.4...v0.3.5) (2022-11-17)

### Features

- **components:** export components types ([#434](https://github.com/themesberg/flowbite-react/issues/434)) ([45ea65a](https://github.com/themesberg/flowbite-react/commit/45ea65a4e1e376b398f462d07b9a1f1ea2ca114b)), closes [#433](https://github.com/themesberg/flowbite-react/issues/433)

### [0.3.4](https://github.com/themesberg/flowbite-react/compare/v0.3.3...v0.3.4) (2022-11-06)

### Bug Fixes

- **DarkThemeToggle:** should toggle the theme with `usePreferences` is false ([#417](https://github.com/themesberg/flowbite-react/issues/417)) ([#424](https://github.com/themesberg/flowbite-react/issues/424)) ([37244ff](https://github.com/themesberg/flowbite-react/commit/37244ff2bbdaecbea8a0bcce0243c8d6f2ee9151))

### [0.3.3](https://github.com/themesberg/flowbite-react/compare/v0.3.2...v0.3.3) (2022-11-04)

### Features

- **breadcrumbitem:** add forwardRef to breadcrumb item ([#421](https://github.com/themesberg/flowbite-react/issues/421)) ([0e4ae62](https://github.com/themesberg/flowbite-react/commit/0e4ae62b2b93561c4857bea63df45fe9170f546e))
- **sidebaritem:** add forwardRef to sidebar item ([#420](https://github.com/themesberg/flowbite-react/issues/420)) ([faca797](https://github.com/themesberg/flowbite-react/commit/faca797b0b8ce7a94b40a44019c7323e721af5e5)), closes [#397](https://github.com/themesberg/flowbite-react/issues/397)

### [0.3.2](https://github.com/themesberg/flowbite-react/compare/v0.3.1...v0.3.2) (2022-10-22)

### Features

- **classname:** more missing classnames access ([#406](https://github.com/themesberg/flowbite-react/issues/406)) ([9e40115](https://github.com/themesberg/flowbite-react/commit/9e4011554cc132fd24bff286955b5f2d6861e1f8))

### [0.3.1](https://github.com/themesberg/flowbite-react/compare/v0.3.0...v0.3.1) (2022-10-22)

### Features

- **classname:** all components with classname access ([#405](https://github.com/themesberg/flowbite-react/issues/405)) ([99b4ceb](https://github.com/themesberg/flowbite-react/commit/99b4cebf5f92e8f3eb15851dcb0b6997c8606c47))

### Bug Fixes

- **avatar:** center avatar correctly ([#404](https://github.com/themesberg/flowbite-react/issues/404)) ([1027212](https://github.com/themesberg/flowbite-react/commit/1027212dc5e3d030c65b418c3710d07d577e4016))

## [0.3.0](https://github.com/themesberg/flowbite-react/compare/v0.2.1...v0.3.0) (2022-10-22)

### [0.2.1](https://github.com/themesberg/flowbite-react/compare/v0.2.0...v0.2.1) (2022-10-19)

### Features

- allow using initials as `Avatar` placeholder ([#375](https://github.com/themesberg/flowbite-react/issues/375)) ([e349d82](https://github.com/themesberg/flowbite-react/commit/e349d82ca1d0933ea037655022b38aa1b9836a33)), closes [#357](https://github.com/themesberg/flowbite-react/issues/357) [#357](https://github.com/themesberg/flowbite-react/issues/357) [#357](https://github.com/themesberg/flowbite-react/issues/357) [#357](https://github.com/themesberg/flowbite-react/issues/357)
- **button:** added forwardRef to button component ([#391](https://github.com/themesberg/flowbite-react/issues/391)) ([3278c84](https://github.com/themesberg/flowbite-react/commit/3278c84ba15bc754032c4e248eb31e64d8bb53ff)), closes [#341](https://github.com/themesberg/flowbite-react/issues/341)
- **themecontext:** exported theme hooks and updated docs ([#390](https://github.com/themesberg/flowbite-react/issues/390)) ([37644b7](https://github.com/themesberg/flowbite-react/commit/37644b7247a35ce15df0379425139585bc8ae27f)), closes [#389](https://github.com/themesberg/flowbite-react/issues/389)

### Bug Fixes

- **dropdown:** close dropdown when item is selected ([#392](https://github.com/themesberg/flowbite-react/issues/392)) ([05f5534](https://github.com/themesberg/flowbite-react/commit/05f5534e972c750b979f6eaa225a5f0f98738ffb)), closes [#349](https://github.com/themesberg/flowbite-react/issues/349) [#349](https://github.com/themesberg/flowbite-react/issues/349) [#349](https://github.com/themesberg/flowbite-react/issues/349)

## [0.2.0](https://github.com/themesberg/flowbite-react/compare/v0.1.12...v0.2.0) (2022-10-11)

### Bug Fixes

- **button:** reduce the thickness of button outline ([#376](https://github.com/themesberg/flowbite-react/issues/376)) ([5ef0aef](https://github.com/themesberg/flowbite-react/commit/5ef0aeff0e90d4de47d1d1e9a954a792a473860d))
- **storybook:** fix welcome page ([#377](https://github.com/themesberg/flowbite-react/issues/377)) ([d2518ad](https://github.com/themesberg/flowbite-react/commit/d2518adf4ace2d062a2f370b18994cd44cebbb42))

### [0.1.12](https://github.com/themesberg/flowbite-react/compare/v0.1.11...v0.1.12) (2022-10-07)

### Bug Fixes

- Button doesn't fit to its parent width ([#370](https://github.com/themesberg/flowbite-react/issues/370)) ([15571aa](https://github.com/themesberg/flowbite-react/commit/15571aa27e7fe96b8aae6e6eaec22e03cab17814))

### [0.1.11](https://github.com/themesberg/flowbite-react/compare/v0.1.10...v0.1.11) (2022-09-13)

### Bug Fixes

- **package:** minimal react version is 18 ([#344](https://github.com/themesberg/flowbite-react/issues/344)) ([bc4fea7](https://github.com/themesberg/flowbite-react/commit/bc4fea7ecbc83dcbff61a5d01805008993a66a71))
- **pagination:** fix next button icon misalignment ([#346](https://github.com/themesberg/flowbite-react/issues/346)) ([0dd10d3](https://github.com/themesberg/flowbite-react/commit/0dd10d339a17961743c6d8a4ceb5c8e06677c0df)), closes [#330](https://github.com/themesberg/flowbite-react/issues/330)

### [0.1.10](https://github.com/themesberg/flowbite-react/compare/v0.1.9...v0.1.10) (2022-08-21)

### Bug Fixes

- **component:** use 1st letter of text in collapsed Sidebar.Item with no icon ([#338](https://github.com/themesberg/flowbite-react/issues/338)) ([103d173](https://github.com/themesberg/flowbite-react/commit/103d17324d388fe60898697ed42811428af169bb)), closes [#81](https://github.com/themesberg/flowbite-react/issues/81)

### [0.1.9](https://github.com/themesberg/flowbite-react/compare/v0.1.8...v0.1.9) (2022-08-19)

### [0.1.8](https://github.com/themesberg/flowbite-react/compare/v0.1.6...v0.1.8) (2022-08-17)

### Bug Fixes

- **component:** add missing display name for checkbox, radio and select ([#328](https://github.com/themesberg/flowbite-react/issues/328)) ([8c307aa](https://github.com/themesberg/flowbite-react/commit/8c307aa1b072d82c2779d5de2dabb5609759689e))

### [0.1.7](https://github.com/themesberg/flowbite-react/compare/v0.1.6...v0.1.7) (2022-08-11)

### [0.1.6](https://github.com/themesberg/flowbite-react/compare/v0.1.5...v0.1.6) (2022-08-11)

### Bug Fixes

- typo in navbar theme typedef ([#327](https://github.com/themesberg/flowbite-react/issues/327)) ([459a864](https://github.com/themesberg/flowbite-react/commit/459a8648f054b80fc4499ecd68689bc3d3d0c244))

### [0.1.5](https://github.com/themesberg/flowbite-react/compare/v0.1.4...v0.1.5) (2022-08-01)

### Bug Fixes

- **component:** remove "All Rights Reserved" from `<Footer.Copyright>` ([#317](https://github.com/themesberg/flowbite-react/issues/317)) ([c6524ee](https://github.com/themesberg/flowbite-react/commit/c6524eea31491480fe85870f22829a96c819c414))

### [0.1.4](https://github.com/themesberg/flowbite-react/compare/v0.1.3...v0.1.4) (2022-07-31)

### Bug Fixes

- **component:** display text only on Sidebar.Item tooltip ([#315](https://github.com/themesberg/flowbite-react/issues/315)) ([9af5d13](https://github.com/themesberg/flowbite-react/commit/9af5d136a95cadd91c3212080bb060091ce3453d)), closes [#258](https://github.com/themesberg/flowbite-react/issues/258)
- **theme:** add z-index to Dropdown floating component ([#314](https://github.com/themesberg/flowbite-react/issues/314)) ([77cb356](https://github.com/themesberg/flowbite-react/commit/77cb3560538751aa256b7c24e71df9fd6bec0c36)), closes [#308](https://github.com/themesberg/flowbite-react/issues/308)

### [0.1.4](https://github.com/themesberg/flowbite-react/compare/v0.1.3...v0.1.4) (2022-07-31)

### [0.1.3](https://github.com/themesberg/flowbite-react/compare/v0.1.2...v0.1.3) (2022-07-06)

### [0.1.2](https://github.com/themesberg/flowbite-react/compare/v0.1.1...v0.1.2) (2022-07-05)

### [0.1.1](https://github.com/themesberg/flowbite-react/compare/v0.1.0...v0.1.1) (2022-07-05)

### Bug Fixes

- **component:** Remove `type="button"` when not a `<button>` ([#217](https://github.com/themesberg/flowbite-react/issues/217)) ([8c7012e](https://github.com/themesberg/flowbite-react/commit/8c7012e77b5ca2abde0b8d30ca1ad38cf70cbdd0))

## [0.1.0](https://github.com/themesberg/flowbite-react/compare/v0.0.27...v0.1.0) (2022-06-30)

### ⚠ BREAKING CHANGES

- **inputs:** Adding theme support to the component blocks the access to className property
  directly

- fix(inputs): fix wrong default color name from `base` to `gray`

- **inputs:** adds theme support to TextInput and FileInput ([#246](https://github.com/themesberg/flowbite-react/issues/246)) ([366a119](https://github.com/themesberg/flowbite-react/commit/366a119fb91710709514dd8e790d0f2246401aa3))

### [0.0.27](https://github.com/themesberg/flowbite-react/compare/v0.0.26...v0.0.27) (2022-06-21)

### Features

- **component:** Add `Accordion.Title` theme for heading ([#184](https://github.com/themesberg/flowbite-react/issues/184)) ([45bc263](https://github.com/themesberg/flowbite-react/commit/45bc2639d03157db4eea5a0933321239596ceeb0))
- **component:** adding helpertext component ([#230](https://github.com/themesberg/flowbite-react/issues/230)) ([dd4e976](https://github.com/themesberg/flowbite-react/commit/dd4e976a64ca5877ed7cb89ae4af00a868a830ae))
- **component:** Allow `Button`s to have `href` ([#209](https://github.com/themesberg/flowbite-react/issues/209)) ([2f9f345](https://github.com/themesberg/flowbite-react/commit/2f9f34540bb86080003b504cc800f9857f8e4953))
- **component:** Allow `Label` as self-closing tag, resolves [#173](https://github.com/themesberg/flowbite-react/issues/173) ([#207](https://github.com/themesberg/flowbite-react/issues/207)) ([17f5e8e](https://github.com/themesberg/flowbite-react/commit/17f5e8e81bdd1c26930b4dd5166dc5f67fd8d761))
- **component:** theme support to darkthemetoggle ([#199](https://github.com/themesberg/flowbite-react/issues/199)) ([1ab7160](https://github.com/themesberg/flowbite-react/commit/1ab7160daa0423a593911a7e1b32aa27e3b25ca3))
- **component:** theme support to modal ([#197](https://github.com/themesberg/flowbite-react/issues/197)) ([3ed4551](https://github.com/themesberg/flowbite-react/commit/3ed455186fe15efadea0f21efaaca87a9292c5fb))
- **component:** theme support to pagination ([#195](https://github.com/themesberg/flowbite-react/issues/195)) ([80b7e2a](https://github.com/themesberg/flowbite-react/commit/80b7e2a364a557f54b94b512fe41c2e4839bd9bc))
- **component:** theme support to rating ([#191](https://github.com/themesberg/flowbite-react/issues/191)) ([c0daead](https://github.com/themesberg/flowbite-react/commit/c0daead778731585b2d6a9dd624eb3c3dbf51cc7))
- **component:** theme support to toast ([#192](https://github.com/themesberg/flowbite-react/issues/192)) ([2d5b556](https://github.com/themesberg/flowbite-react/commit/2d5b556507c234b3c77a7d7a2d1c542c2324f056))
- **component:** theme support to tooltip ([#198](https://github.com/themesberg/flowbite-react/issues/198)) ([957ea45](https://github.com/themesberg/flowbite-react/commit/957ea4569e1fb8802f5a5d0386607d12c682c2c0))
- **component:** Use `FlowbiteTheme` in `Sidebar`s, resolves [#143](https://github.com/themesberg/flowbite-react/issues/143) ([#200](https://github.com/themesberg/flowbite-react/issues/200)) ([59654eb](https://github.com/themesberg/flowbite-react/commit/59654eb1182e6df8f528d7a25ec8d817e6f18acc))
- **component:** Use theme in `ListGroup`s, resolves [#137](https://github.com/themesberg/flowbite-react/issues/137) ([#203](https://github.com/themesberg/flowbite-react/issues/203)) ([360a723](https://github.com/themesberg/flowbite-react/commit/360a7235625fc8e8da01a0bf0d70e18064e40d83))

### Bug Fixes

- `nanoid` requires Node `crypto` module ([#185](https://github.com/themesberg/flowbite-react/issues/185)) ([da59ccc](https://github.com/themesberg/flowbite-react/commit/da59ccca0900a14fd0e8720041dd4830aa04984c))
- **a11y:** Use darker text for `Breadcrumb.Item`s, resolves [#102](https://github.com/themesberg/flowbite-react/issues/102) ([b6fcf6a](https://github.com/themesberg/flowbite-react/commit/b6fcf6ac6c8107a7b6bdaa515f20e5bc6e252d20))
- **build:** Change `yarn lint` command to actually lint files ([#183](https://github.com/themesberg/flowbite-react/issues/183)) ([3471318](https://github.com/themesberg/flowbite-react/commit/34713188352c5da675de7e57ffabe92f9443cc61))
- **carousel:** carousel size depends on parent size ([#241](https://github.com/themesberg/flowbite-react/issues/241)) ([279eab4](https://github.com/themesberg/flowbite-react/commit/279eab494906de81c46b569115b9fe578d91a2cf))
- **component:** add displayName to TextInput ([#219](https://github.com/themesberg/flowbite-react/issues/219)) ([cb5ca89](https://github.com/themesberg/flowbite-react/commit/cb5ca8929d86e3c179d833ae246b1c9e35c63e51))
- **component:** add forwardRef to TextInput ([#212](https://github.com/themesberg/flowbite-react/issues/212)) ([596a445](https://github.com/themesberg/flowbite-react/commit/596a4453dd77adb361dd3dfea3b8d6650be5e91c))
- **component:** Allow `Card` to have `href` ([#194](https://github.com/themesberg/flowbite-react/issues/194)) ([3be9786](https://github.com/themesberg/flowbite-react/commit/3be9786471f5847e1307fa76319bea4e11eec718))
- **component:** Allow `Carousel`s to fill height, resolves [#168](https://github.com/themesberg/flowbite-react/issues/168) ([#208](https://github.com/themesberg/flowbite-react/issues/208)) ([9ccf0c2](https://github.com/themesberg/flowbite-react/commit/9ccf0c2a2499d50ae9c9da953a4bcbedb0cc41ca))
- **type:** Generate `FlowbiteTheme.d.ts` to builds ([#182](https://github.com/themesberg/flowbite-react/issues/182)) ([097d875](https://github.com/themesberg/flowbite-react/commit/097d8756c0130c663e3e1db15a016e8caa5316bf))
- update typo on Footer.Link from Gihub to Github ([#210](https://github.com/themesberg/flowbite-react/issues/210)) ([7ca9fcc](https://github.com/themesberg/flowbite-react/commit/7ca9fccd86d140ea89e52858bb59e288203bde47))

### [0.0.26](https://github.com/themesberg/flowbite-react/compare/v0.0.25...v0.0.26) (2022-06-13)

### Features

- **component:** Add `Accordion.Title` theme for heading ([#184](https://github.com/themesberg/flowbite-react/issues/184)) ([45bc263](https://github.com/themesberg/flowbite-react/commit/45bc2639d03157db4eea5a0933321239596ceeb0))
- **component:** Allow `Button`s to have `href` ([#209](https://github.com/themesberg/flowbite-react/issues/209)) ([2f9f345](https://github.com/themesberg/flowbite-react/commit/2f9f34540bb86080003b504cc800f9857f8e4953))
- **component:** Allow `Label` as self-closing tag, resolves [#173](https://github.com/themesberg/flowbite-react/issues/173) ([#207](https://github.com/themesberg/flowbite-react/issues/207)) ([17f5e8e](https://github.com/themesberg/flowbite-react/commit/17f5e8e81bdd1c26930b4dd5166dc5f67fd8d761))
- **component:** theme support to darkthemetoggle ([#199](https://github.com/themesberg/flowbite-react/issues/199)) ([1ab7160](https://github.com/themesberg/flowbite-react/commit/1ab7160daa0423a593911a7e1b32aa27e3b25ca3))
- **component:** theme support to modal ([#197](https://github.com/themesberg/flowbite-react/issues/197)) ([3ed4551](https://github.com/themesberg/flowbite-react/commit/3ed455186fe15efadea0f21efaaca87a9292c5fb))
- **component:** theme support to pagination ([#195](https://github.com/themesberg/flowbite-react/issues/195)) ([80b7e2a](https://github.com/themesberg/flowbite-react/commit/80b7e2a364a557f54b94b512fe41c2e4839bd9bc))
- **component:** theme support to rating ([#191](https://github.com/themesberg/flowbite-react/issues/191)) ([c0daead](https://github.com/themesberg/flowbite-react/commit/c0daead778731585b2d6a9dd624eb3c3dbf51cc7))
- **component:** theme support to toast ([#192](https://github.com/themesberg/flowbite-react/issues/192)) ([2d5b556](https://github.com/themesberg/flowbite-react/commit/2d5b556507c234b3c77a7d7a2d1c542c2324f056))
- **component:** theme support to tooltip ([#198](https://github.com/themesberg/flowbite-react/issues/198)) ([957ea45](https://github.com/themesberg/flowbite-react/commit/957ea4569e1fb8802f5a5d0386607d12c682c2c0))
- **component:** Use `FlowbiteTheme` in `Sidebar`s, resolves [#143](https://github.com/themesberg/flowbite-react/issues/143) ([#200](https://github.com/themesberg/flowbite-react/issues/200)) ([59654eb](https://github.com/themesberg/flowbite-react/commit/59654eb1182e6df8f528d7a25ec8d817e6f18acc))
- **component:** Use theme in `ListGroup`s, resolves [#137](https://github.com/themesberg/flowbite-react/issues/137) ([#203](https://github.com/themesberg/flowbite-react/issues/203)) ([360a723](https://github.com/themesberg/flowbite-react/commit/360a7235625fc8e8da01a0bf0d70e18064e40d83))

### Bug Fixes

- `nanoid` requires Node `crypto` module ([#185](https://github.com/themesberg/flowbite-react/issues/185)) ([da59ccc](https://github.com/themesberg/flowbite-react/commit/da59ccca0900a14fd0e8720041dd4830aa04984c))
- **a11y:** Use darker text for `Breadcrumb.Item`s, resolves [#102](https://github.com/themesberg/flowbite-react/issues/102) ([b6fcf6a](https://github.com/themesberg/flowbite-react/commit/b6fcf6ac6c8107a7b6bdaa515f20e5bc6e252d20))
- **build:** Change `yarn lint` command to actually lint files ([#183](https://github.com/themesberg/flowbite-react/issues/183)) ([3471318](https://github.com/themesberg/flowbite-react/commit/34713188352c5da675de7e57ffabe92f9443cc61))
- **component:** add displayName to TextInput ([#219](https://github.com/themesberg/flowbite-react/issues/219)) ([cb5ca89](https://github.com/themesberg/flowbite-react/commit/cb5ca8929d86e3c179d833ae246b1c9e35c63e51))
- **component:** add forwardRef to TextInput ([#212](https://github.com/themesberg/flowbite-react/issues/212)) ([596a445](https://github.com/themesberg/flowbite-react/commit/596a4453dd77adb361dd3dfea3b8d6650be5e91c))
- **component:** Allow `Card` to have `href` ([#194](https://github.com/themesberg/flowbite-react/issues/194)) ([3be9786](https://github.com/themesberg/flowbite-react/commit/3be9786471f5847e1307fa76319bea4e11eec718))
- **component:** Allow `Carousel`s to fill height, resolves [#168](https://github.com/themesberg/flowbite-react/issues/168) ([#208](https://github.com/themesberg/flowbite-react/issues/208)) ([9ccf0c2](https://github.com/themesberg/flowbite-react/commit/9ccf0c2a2499d50ae9c9da953a4bcbedb0cc41ca))
- **component:** Remove default export from `Breadcrumb` ([#150](https://github.com/themesberg/flowbite-react/issues/150)) ([511a86c](https://github.com/themesberg/flowbite-react/commit/511a86c8a55b6823f8dd80d916a20b49181705a5))
- Replace old colors on `Alerts` page & stories ([#156](https://github.com/themesberg/flowbite-react/issues/156)) ([4619168](https://github.com/themesberg/flowbite-react/commit/46191683cc2e28d0bdfce459c7eabeb10983e0f1))
- **type:** Generate `FlowbiteTheme.d.ts` to builds ([#182](https://github.com/themesberg/flowbite-react/issues/182)) ([097d875](https://github.com/themesberg/flowbite-react/commit/097d8756c0130c663e3e1db15a016e8caa5316bf))
- update typo on Footer.Link from Gihub to Github ([#210](https://github.com/themesberg/flowbite-react/issues/210)) ([7ca9fcc](https://github.com/themesberg/flowbite-react/commit/7ca9fccd86d140ea89e52858bb59e288203bde47))
- You may want the label to be the number 0 ([#157](https://github.com/themesberg/flowbite-react/issues/157)) ([396d8f3](https://github.com/themesberg/flowbite-react/commit/396d8f34ec6621a3936bee132de303c90acba1e5))

### [0.0.25](https://github.com/themesberg/flowbite-react/compare/v0.0.24...v0.0.25) (2022-05-20)

### Bug Fixes

- **component:** Check for `window` in components ([#124](https://github.com/themesberg/flowbite-react/issues/124)) ([4b3b8c5](https://github.com/themesberg/flowbite-react/commit/4b3b8c5f0419e0d3aa80d751ef71a01e8a075e93)), closes [#123](https://github.com/themesberg/flowbite-react/issues/123)

### [0.0.24](https://github.com/themesberg/flowbite-react/compare/v0.0.23...v0.0.24) (2022-05-15)

### [0.0.23](https://github.com/themesberg/flowbite-react/compare/v0.0.22...v0.0.23) (2022-05-12)

### [0.0.22](https://github.com/themesberg/flowbite-react/compare/v0.0.21...v0.0.22) (2022-05-10)

### Bug Fixes

- refactor sidebar item to accept a component as wrapper ([#96](https://github.com/themesberg/flowbite-react/issues/96)) ([c934624](https://github.com/themesberg/flowbite-react/commit/c9346248641253f16fa0b5424a6a25b2cb31b875))

### [0.0.21](https://github.com/themesberg/flowbite-react/compare/v0.0.19...v0.0.21) (2022-05-10)

### Features

- add tab component ([#87](https://github.com/themesberg/flowbite-react/issues/87)) ([e94cceb](https://github.com/themesberg/flowbite-react/commit/e94cceb0f88302a9681a2cc9555bff5d2a532df9))
- adds footer component ([#59](https://github.com/themesberg/flowbite-react/issues/59)) ([7799f15](https://github.com/themesberg/flowbite-react/commit/7799f15d4adf89e8cc21fef3b2553120c9a261db))
- **build:** Add `cypress` for end-to-end (integration) testing ([#85](https://github.com/themesberg/flowbite-react/issues/85)) ([4df13e6](https://github.com/themesberg/flowbite-react/commit/4df13e6dff826ae9af2859e4ba3b92abb5e4bb06))
- flowbite theme context provider ([#61](https://github.com/themesberg/flowbite-react/issues/61)) ([7274f5e](https://github.com/themesberg/flowbite-react/commit/7274f5e20a5111f1c7c43c63fd497c8a34a0950f))
- **route:** Add `Sidebar` examples page & stories, resolving [#53](https://github.com/themesberg/flowbite-react/issues/53) [#56](https://github.com/themesberg/flowbite-react/issues/56) ([#69](https://github.com/themesberg/flowbite-react/issues/69)) ([38b86bd](https://github.com/themesberg/flowbite-react/commit/38b86bd8b10fb4d5c310f0cf214c5e935021f3cd))

### Bug Fixes

- **docs:** Update `README` Components links to new URL pattern ([#84](https://github.com/themesberg/flowbite-react/issues/84)) ([39c2d91](https://github.com/themesberg/flowbite-react/commit/39c2d91c02528b56231e374de0b34d8593344d97))
- fix Carousel styles ([78060ea](https://github.com/themesberg/flowbite-react/commit/78060ea820f4b52c3b4e27acddd6d656ff91e5c7))
- improving flow handling ([#86](https://github.com/themesberg/flowbite-react/issues/86)) ([dc8af66](https://github.com/themesberg/flowbite-react/commit/dc8af66f24fa218f4152fff29c87d4620ada4bb3))
- refactor sidebar item to accept a component as wrapper ([1c964eb](https://github.com/themesberg/flowbite-react/commit/1c964eb1cbfa458d3595e2e0d367e6479dd65992))

### [0.0.20](https://github.com/themesberg/flowbite-react/compare/v0.0.19...v0.0.20) (2022-05-02)

### [0.0.19](https://github.com/themesberg/flowbite-react/compare/v0.0.18...v0.0.19) (2022-05-02)

### Features

- adds more alert stories ([a99abc9](https://github.com/themesberg/flowbite-react/commit/a99abc9dd192e860949797721b9a56b7aba32ff1))
- adds the addicional ([bcd268e](https://github.com/themesberg/flowbite-react/commit/bcd268e50efbee744f4167bf9c4b4a6f1c9582a0))
- **build:** Upgrade `@popperjs/*` to `@floating-ui/react-*` ([#67](https://github.com/themesberg/flowbite-react/issues/67)) ([9ba11ef](https://github.com/themesberg/flowbite-react/commit/9ba11ef1830b42c9c3279797c3166c78a2ec325d)), closes [#57](https://github.com/themesberg/flowbite-react/issues/57) [#69](https://github.com/themesberg/flowbite-react/issues/69)
- **component:** Add `alt` attribute to `Avatar`s ([d803781](https://github.com/themesberg/flowbite-react/commit/d80378129414957bf8b0126e63c825361aaf0adf))
- **content:** Add example `Avatar` with `alt` ([b619076](https://github.com/themesberg/flowbite-react/commit/b619076ce94d14117b23460c8a6072bcf956e8db))
- **content:** Add example `Card` with image with `alt` text ([7410610](https://github.com/themesberg/flowbite-react/commit/74106100888339d4febdb6a32bcaed57a5dae90e))

### Bug Fixes

- cleaning ([a7e1382](https://github.com/themesberg/flowbite-react/commit/a7e138286b1f9f6bda8e05d01ecf6cd698f2371e))
- **component:** Add `displayName`s for syntax highlighter, resolving [#70](https://github.com/themesberg/flowbite-react/issues/70) ([#73](https://github.com/themesberg/flowbite-react/issues/73)) ([6741a83](https://github.com/themesberg/flowbite-react/commit/6741a837a2a739b3f208594b0b1d24f39035c5a7))
- imports for alert component ([f7d6ce0](https://github.com/themesberg/flowbite-react/commit/f7d6ce03652a3d86a5a7f58fd686ba278b9315a1))
- the badge size ([14b25da](https://github.com/themesberg/flowbite-react/commit/14b25da43674dde62282b547a063624ccee201ee))
- use createPortal to render modals ([#77](https://github.com/themesberg/flowbite-react/issues/77)) ([e5e5e2e](https://github.com/themesberg/flowbite-react/commit/e5e5e2ea13285906caa4c5db9d4fc521a66fc2a7))

### [0.0.18](https://github.com/themesberg/flowbite-react/compare/v0.0.17...v0.0.18) (2022-04-20)

### Features

- add ability to drag to scroll for the Carousel component ([eb91078](https://github.com/themesberg/flowbite-react/commit/eb91078cd0a40e9411535af9a0cf3399c2cf7c0d))
- adds avatar group ([c1c3d48](https://github.com/themesberg/flowbite-react/commit/c1c3d483c33a931df74f5c55c0e11e8100b97738))
- adds the avatar component to the storybook ([e2f3a22](https://github.com/themesberg/flowbite-react/commit/e2f3a22ba76c832d65ddd667d2eb76fd314b3dee))

### Bug Fixes

- fix Carousel controls clicking behavior ([3fa9180](https://github.com/themesberg/flowbite-react/commit/3fa9180ff636038d75d499f6b9812dfa543d5d86))
- improvement the dropdown stories ([1ab98cc](https://github.com/themesberg/flowbite-react/commit/1ab98cc56120234442e46c1fd585e61c8598714c))
- remove unused import from Avatar.tsx ([ebe43ff](https://github.com/themesberg/flowbite-react/commit/ebe43ffcd54af8dacffae7a68b3e78c6d91ab534))

### [0.0.17](https://github.com/themesberg/flowbite-react/compare/v0.0.16...v0.0.17) (2022-04-14)

### Features

- add Table component ([7568ccc](https://github.com/themesberg/flowbite-react/commit/7568ccc3f299501e6042f2c93a44599677735d1c))

### Bug Fixes

- add missing dark class names of the progress component ([09cfef4](https://github.com/themesberg/flowbite-react/commit/09cfef49d6a52a01cca814e22ca35eef4ba65992))
- add missing label prop usage in the Button component ([5e8c291](https://github.com/themesberg/flowbite-react/commit/5e8c291351fec7c3ff327eea0b9635996bde534a))
- added 700 duration to Duration type ([efd4611](https://github.com/themesberg/flowbite-react/commit/efd461171eaff21c37be189acb6d0c66fce791c7))
- added PropsWithChildren ([3090117](https://github.com/themesberg/flowbite-react/commit/3090117cb0f177031da33e2db41287339663b847))
- added testid, merged imports, added duration record ([c5c9cd5](https://github.com/themesberg/flowbite-react/commit/c5c9cd538d76a7a19840ea18e9b6e48ae0a594f2))
- avatar bordered ([432d9f5](https://github.com/themesberg/flowbite-react/commit/432d9f594f8f5eba3e65a7c464ea49516c4c88bc))
- correctly renamed toast to Toast ([fd5d162](https://github.com/themesberg/flowbite-react/commit/fd5d162b5134cc0bda73a673ebc353514ebe9467))
- correctly renamed Toast.tsx to index.tsx ([53881df](https://github.com/themesberg/flowbite-react/commit/53881dfccd17f12af9c151c00792c4b0fd646f8a))
- exclude storybook stories while building the library ([648b110](https://github.com/themesberg/flowbite-react/commit/648b1107052ffe8ebe2c041dba427f62013e0185))
- export Size type and merged imports ([55c9cdf](https://github.com/themesberg/flowbite-react/commit/55c9cdf3835b93793b1a2696a4ac0cefcda4e0a9))
- fix Button component styling ([c0683cf](https://github.com/themesberg/flowbite-react/commit/c0683cf8365235b436331710bd2a84c61a9cdd3e))
- imported Size type from RatingContext ([bd8ebbb](https://github.com/themesberg/flowbite-react/commit/bd8ebbbd330de3afc2b64095ce875aa2822880ca))
- make arrow prop of Dropdown component much understandable ([cc1beff](https://github.com/themesberg/flowbite-react/commit/cc1beffb41a6146d1a38417cb3fbde3de787f938))
- make label prop of Button component as ReactNode ([59cee65](https://github.com/themesberg/flowbite-react/commit/59cee65a58623d138098fb3cfcc3c67d2a7e8d19))
- removed svg component props ([195b67e](https://github.com/themesberg/flowbite-react/commit/195b67eae27fe48a5c923a1b6cf789b7f9ff0482))
- removed Toast.tsx from src/ ([0f0c362](https://github.com/themesberg/flowbite-react/commit/0f0c36219b626b10da252dd58e3fb353f79cdbb7))
- removed unneeded imports ([249e40e](https://github.com/themesberg/flowbite-react/commit/249e40e7209ee614f71cee240f69397364151501))
- removed unneeded imports from stories ([a731a2c](https://github.com/themesberg/flowbite-react/commit/a731a2c4500a9ccc74a1491bf43cdb25cbc8ea7c))
- replaced star svg with HiStar icon ([259f345](https://github.com/themesberg/flowbite-react/commit/259f3457a9f7797cd0d6af4114b58282a14138a1))
- set tooltipArrow prop as false by default for the Dropdown component ([35ad443](https://github.com/themesberg/flowbite-react/commit/35ad443ab4bbc77cb1a2ab72e3ffd00805bcf073))
- simplify routes array ([52cb973](https://github.com/themesberg/flowbite-react/commit/52cb973c080f8ce6b5001ce3e33cea5c3f51d46a))

### [0.0.16](https://github.com/themesberg/flowbite-react/compare/v0.0.15...v0.0.16) (2022-04-08)

### Features

- add Modal components ([df5713c](https://github.com/themesberg/flowbite-react/commit/df5713ca60a8edcfc49337d8c5ac9db1ff03c42c))
- add React 18 support ([10ddd73](https://github.com/themesberg/flowbite-react/commit/10ddd73fe3c90efd98da61e362cd301353549fc5))
- Create Navbar ([253944a](https://github.com/themesberg/flowbite-react/commit/253944abb494e345c6a6693f18b4a42541a53165))
- Create Navbar example page ([670da6b](https://github.com/themesberg/flowbite-react/commit/670da6bc9fb644b6026c0f5cdc18a66449090db6))

### Bug Fixes

- added border for dark mode ([cfdf462](https://github.com/themesberg/flowbite-react/commit/cfdf462970ea31007725c9ab3ddf18dacbe935a0))
- changed navbar logo display name ([a0caa49](https://github.com/themesberg/flowbite-react/commit/a0caa493b29bd1bae903a1c4a0c95bfea1704eca))
- changed Navbar.Logo to Navbar.Brand ([5ecee8b](https://github.com/themesberg/flowbite-react/commit/5ecee8b0a069b8c5ed9da5b134a768e38a5d9464))
- misspelled NavbarComponent ([ad183a8](https://github.com/themesberg/flowbite-react/commit/ad183a88f0e4a41af85b8534183b19c670ec7a6e))
- removed commit for Tab component ([629d86c](https://github.com/themesberg/flowbite-react/commit/629d86c3938dea59ed219186014b0cac35644b7f))
- removed linter ignore ([950921a](https://github.com/themesberg/flowbite-react/commit/950921a3b8bdb79cdc849403b11f466773059321))
- removed linter ignore for hidden className ([7fe9e3e](https://github.com/themesberg/flowbite-react/commit/7fe9e3e8041f30a411626b87868eea30be4f663f))
- removed test link ([129c9e2](https://github.com/themesberg/flowbite-react/commit/129c9e29855463bdfe5105ad0e74b7d1c6f2228d))
- removed typo around a className ([d3fcd0f](https://github.com/themesberg/flowbite-react/commit/d3fcd0f5ca7e52a5ecf187120fde54175332013c))

### [0.0.15](https://github.com/themesberg/flowbite-react/compare/v0.0.14...v0.0.15) (2022-03-21)

### [0.0.14](https://github.com/themesberg/flowbite-react/compare/v0.0.13...v0.0.14) (2022-03-21)

### Features

- refactor ListGroup component ([0f18211](https://github.com/themesberg/flowbite-react/commit/0f182113f982cfbc8b5664f7946b8bcf6312cb8e))

### Bug Fixes

- fix ListGroup component ([5eda5ed](https://github.com/themesberg/flowbite-react/commit/5eda5ed993f4f7938ce332599166c2fbd2f837ee))

### [0.0.13](https://github.com/themesberg/flowbite-react/compare/v0.0.12...v0.0.13) (2022-03-17)

### Features

- add Dropdown component ([169b46e](https://github.com/themesberg/flowbite-react/commit/169b46e3bc59629a25f6badc1e6e8df0786b7ede))
- add Forms components ([51c2486](https://github.com/themesberg/flowbite-react/commit/51c248631ae4f844bc21cc54456b5ef202d7015e))
- refactor Accordion component ([16482e3](https://github.com/themesberg/flowbite-react/commit/16482e382a213af74797161ab1e75f5405a2312f))

### Bug Fixes

- fix Button styling ([c4aad36](https://github.com/themesberg/flowbite-react/commit/c4aad365d68ab3ea17e805c0fa0bc438a1d83924))
- fix onclick func and button focus in dark mode ([a8b6c92](https://github.com/themesberg/flowbite-react/commit/a8b6c92184115a6d2f967bf1bdaa2ca0a00d52b8))
- refactor Accordion component ([96dc14c](https://github.com/themesberg/flowbite-react/commit/96dc14c41530bd57db18b394fdf3a018c5463275))

### [0.0.12](https://github.com/themesberg/flowbite-react/compare/v0.0.11...v0.0.12) (2022-03-13)

### Features

- add Button group component ([1f8b8fd](https://github.com/themesberg/flowbite-react/commit/1f8b8fd6026d6cadc87263406c98c9202e5874ba))

### [0.0.11](https://github.com/themesberg/flowbite-react/compare/v0.0.10...v0.0.11) (2022-03-13)

### Features

- add light prop to Spinner component ([0590d66](https://github.com/themesberg/flowbite-react/commit/0590d66f6bd5046be13fa450bc6f5c575810cc08))

### Bug Fixes

- Remove extra icon content from Button component ([2762b55](https://github.com/themesberg/flowbite-react/commit/2762b5559d6404d1a50976643742891ee851cb9a))

### [0.0.10](https://github.com/themesberg/flowbite-react/compare/v0.0.9...v0.0.10) (2022-03-13)

### Features

- add Carousel component ([36014bc](https://github.com/themesberg/flowbite-react/commit/36014bc30d45033228150b9d78899b3be15bf181))

### Bug Fixes

- resolve issues ([118d301](https://github.com/themesberg/flowbite-react/commit/118d301e4a6e026eafdac4ef3dca9dda5aabf55d))
- resolve issues ([3294f5b](https://github.com/themesberg/flowbite-react/commit/3294f5bf024b207f829806abcf27e84df3f46199))
- resolve issues, change spinner sizes ([1b4668a](https://github.com/themesberg/flowbite-react/commit/1b4668a5adc7be8f2bb91b91c24d0e8c70709137))

### [0.0.9](https://github.com/themesberg/flowbite-react/compare/v0.0.6...v0.0.9) (2022-03-12)

### Features

- add Card component ([6c3d067](https://github.com/themesberg/flowbite-react/commit/6c3d067eb01022d5e444c38362b917aaa4c0f9d7))
- add spinner component ([61c417d](https://github.com/themesberg/flowbite-react/commit/61c417dcc73df86339d5e6499b79873db2fb8a30))
- use react-icons icons library ([236ba62](https://github.com/themesberg/flowbite-react/commit/236ba627fe2da61938cce05b16fc865c76a83e8a))
- use tooltips when sidebar is collapsed ([17ecd1a](https://github.com/themesberg/flowbite-react/commit/17ecd1a45a6dc6ad504e33dd4b1af968e7f97314))

### [0.0.8](https://github.com/themesberg/flowbite-react/compare/v0.0.6...v0.0.8) (2022-03-12)

### Features

- add spinner component ([f712228](https://github.com/themesberg/flowbite-react/commit/f7122285695db48eb6b2402f3f568a0d18cc95fd))
- use react-icons icons library ([236ba62](https://github.com/themesberg/flowbite-react/commit/236ba627fe2da61938cce05b16fc865c76a83e8a))

### [0.0.7](https://github.com/themesberg/flowbite-react/compare/v0.0.6...v0.0.7) (2022-03-12)

### Features

- use react-icons icons library ([236ba62](https://github.com/themesberg/flowbite-react/commit/236ba627fe2da61938cce05b16fc865c76a83e8a))

### [0.0.6](https://github.com/themesberg/flowbite-react/compare/v0.0.5...v0.0.6) (2022-03-12)

### Features

- add tooltip component ([d2edbb7](https://github.com/themesberg/flowbite-react/commit/d2edbb78f91d632a832c0ee5b993080f07de46c9))

### Bug Fixes

- Edit Accordion.tsx ([1110731](https://github.com/themesberg/flowbite-react/commit/1110731209c4976f1539cf4fca777b8587783bc0))
- use React state instead of data-\* attributes in Sidebar.tsx ([3942ddd](https://github.com/themesberg/flowbite-react/commit/3942ddd65111d67f465c421720ab9a4c24af5e4d))

### [0.0.5](https://github.com/themesberg/flowbite-react/compare/v0.0.4...v0.0.5) (2022-03-05)

### Features

- Add Badges and Breadcrumb ([7b7b288](https://github.com/themesberg/flowbite-react/commit/7b7b288763aee5d2baebc8052f370f60e8d9df3a))

### [0.0.4](https://github.com/themesberg/flowbite-react/compare/v0.0.3...v0.0.4) (2022-03-02)

### Bug Fixes

- fix Sidebar links ([c157d32](https://github.com/themesberg/flowbite-react/commit/c157d3224aa88a18b29090ecd03d71450a022fdd))

### [0.0.3](https://github.com/themesberg/flowbite-react/compare/v0.0.2...v0.0.3) (2022-03-02)

### Features

- add Alert component ([d3cb7b7](https://github.com/themesberg/flowbite-react/commit/d3cb7b7effd52d2180666bd5ed564ace6e8474af))

### [0.0.2](https://github.com/themesberg/flowbite-react/compare/v0.0.1...v0.0.2) (2022-02-28)

### 0.0.1 (2022-02-28)
