"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DarkThemeToggle = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const hi_1 = require("react-icons/hi");
const tailwind_merge_1 = require("tailwind-merge");
const __1 = require("../../");
const ThemeContext_1 = require("../../components/Flowbite/ThemeContext");
const merge_deep_1 = require("../../helpers/merge-deep");
const DarkThemeToggle = ({ className, theme: customTheme = {}, iconDark: IconDark = hi_1.HiSun, iconLight: IconLight = hi_1.HiMoon, ...props }) => {
    const theme = (0, merge_deep_1.mergeDeep)((0, __1.useTheme)().theme.darkThemeToggle, customTheme);
    const { mode, toggleMode } = (0, react_1.useContext)(ThemeContext_1.ThemeContext);
    return ((0, jsx_runtime_1.jsx)("button", { "aria-label": "Toggle dark mode", "data-testid": "dark-theme-toggle", onClick: toggleMode, type: "button", className: (0, tailwind_merge_1.twMerge)(theme.root.base, className), ...props, children: mode === 'dark' ? ((0, jsx_runtime_1.jsx)(IconLight, { "aria-label": "Currently dark mode", className: theme.root.icon })) : ((0, jsx_runtime_1.jsx)(IconDark, { "aria-label": "Currently light mode", className: theme.root.icon })) }));
};
exports.DarkThemeToggle = DarkThemeToggle;
exports.DarkThemeToggle.displayName = 'DarkThemeToggle';
