"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useThemeMode = exports.useTheme = exports.Flowbite = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const __1 = require("../../");
const merge_deep_1 = require("../../helpers/merge-deep");
const ThemeContext_1 = require("./ThemeContext");
Object.defineProperty(exports, "useTheme", { enumerable: true, get: function () { return ThemeContext_1.useTheme; } });
Object.defineProperty(exports, "useThemeMode", { enumerable: true, get: function () { return ThemeContext_1.useThemeMode; } });
const Flowbite = ({ children, theme = {} }) => {
    const { theme: customTheme = {}, dark } = theme;
    const [mode, setMode, toggleMode] = (0, ThemeContext_1.useThemeMode)();
    const mergedTheme = (0, merge_deep_1.mergeDeep)(__1.theme, customTheme);
    (0, react_1.useEffect)(() => {
        if (dark) {
            setMode('dark');
            document.documentElement.classList.add('dark');
        }
        else {
            setMode('light');
            document.documentElement.classList.remove('dark');
        }
    }, [dark, setMode]);
    const themeContextValue = (0, react_1.useMemo)(() => ({
        theme: mergedTheme,
        mode,
        toggleMode,
    }), [mode, toggleMode, mergedTheme]);
    return (0, jsx_runtime_1.jsx)(ThemeContext_1.ThemeContext.Provider, { value: themeContextValue, children: children });
};
exports.Flowbite = Flowbite;
exports.Flowbite.displayName = 'Flowbite';
