"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Modal = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const react_dom_1 = require("react-dom");
const tailwind_merge_1 = require("tailwind-merge");
const __1 = require("../../");
const is_client_1 = require("../../helpers/is-client");
const merge_deep_1 = require("../../helpers/merge-deep");
const ModalBody_1 = require("./ModalBody");
const ModalContext_1 = require("./ModalContext");
const ModalFooter_1 = require("./ModalFooter");
const ModalHeader_1 = require("./ModalHeader");
const ModalComponent = ({ children, className, dismissible = false, onClose, popup, position = 'center', root, show, size = '2xl', theme: customTheme = {}, ...props }) => {
    const theme = (0, merge_deep_1.mergeDeep)((0, __1.useTheme)().theme.modal, customTheme);
    const [mounted, setMounted] = (0, react_1.useState)(false);
    // Declare a ref to store a reference to a div element.
    const containerRef = (0, react_1.useRef)(null);
    (0, react_1.useEffect)(() => {
        setMounted(true);
        return () => {
            const container = containerRef.current;
            // If a container exists on unmount, it is removed from the DOM and
            // garbage collected.
            if (container) {
                container.parentNode?.removeChild(container);
                containerRef.current = null;
            }
        };
    }, []);
    // Close modal when escape key is pressed
    (0, react_1.useEffect)(() => {
        const handleKeyDown = (event) => {
            if (event.key === 'Escape' && onClose) {
                onClose();
            }
        };
        document.addEventListener('keydown', handleKeyDown);
        return () => {
            document.removeEventListener('keydown', handleKeyDown);
        };
    }, [onClose]);
    if (!mounted) {
        return null;
    }
    // If the current value of the ref is falsy (e.g. null), set it to a new div
    // element.
    if (!containerRef.current) {
        containerRef.current = document.createElement('div');
    }
    // If the current value of the ref is not already a child of the root element,
    // append it or replace its parent.
    if ((0, is_client_1.isClient)() && containerRef.current.parentNode !== root) {
        root ||= document.body;
        root.appendChild(containerRef.current);
        // Prevent scrolling of the root element when the modal is shown
        root.style.overflow = show ? 'hidden' : '';
    }
    const handleOnClick = (e) => {
        if (dismissible && e.target === e.currentTarget && onClose) {
            onClose();
        }
    };
    return (0, react_dom_1.createPortal)((0, jsx_runtime_1.jsx)(ModalContext_1.ModalContext.Provider, { value: { popup, onClose }, children: (0, jsx_runtime_1.jsx)("div", { "aria-hidden": !show, "data-testid": "modal", onClick: handleOnClick, role: "dialog", className: (0, tailwind_merge_1.twMerge)(theme.root.base, theme.root.positions[position], show ? theme.root.show.on : theme.root.show.off, className), ...props, children: (0, jsx_runtime_1.jsx)("div", { className: (0, tailwind_merge_1.twMerge)(theme.content.base, theme.root.sizes[size]), children: (0, jsx_runtime_1.jsx)("div", { className: theme.content.inner, children: children }) }) }) }), containerRef.current);
};
ModalComponent.displayName = 'Modal';
ModalHeader_1.ModalHeader.displayName = 'Modal.Header';
ModalBody_1.ModalBody.displayName = 'Modal.Body';
ModalFooter_1.ModalFooter.displayName = 'Modal.Footer';
exports.Modal = Object.assign(ModalComponent, { Header: ModalHeader_1.ModalHeader, Body: ModalBody_1.ModalBody, Footer: ModalFooter_1.ModalFooter });
