import { jsx as _jsx } from "react/jsx-runtime";
import { twMerge } from 'tailwind-merge';
import { useTheme } from '../../';
import { mergeDeep } from '../../helpers/merge-deep';
import { useAccordionContext } from './AccordionPanelContext';
export const AccordionContent = ({ children, className, theme: customTheme = {}, ...props }) => {
    const { isOpen } = useAccordionContext();
    const theme = mergeDeep(useTheme().theme.accordion.content, customTheme);
    return (_jsx("div", { className: twMerge(theme.base, className), "data-testid": "flowbite-accordion-content", hidden: !isOpen, ...props, children: children }));
};
